/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.ActionStatus;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.PathfinderServices;

public class Action {
    private static final Logger logger = LoggerFactory.getLogger(Action.class);
    private final ActionStatus status;
    private final double latitude;
    private final double longitude;
    private final Commodity commodity;

    protected Action(JsonObject actionJson, PathfinderServices services) {
        logger.info("Constructing action: " + actionJson.toString());
        this.status = Action.getStatus(actionJson);
        this.latitude = Action.getLatitude(actionJson);
        this.longitude = Action.getLongitude(actionJson);
        this.commodity = !this.status.equals((Object)ActionStatus.START) ? Action.getCommodity(actionJson, services) : null;
        logger.info("Done constructing action: " + this.toString());
    }

    private static ActionStatus getStatus(JsonObject json) {
        return Action.getStatus(json.get("action").getAsString());
    }

    private static ActionStatus getStatus(String status) {
        return ActionStatus.getStatus(status);
    }

    private static double getLatitude(JsonObject json) {
        return json.get("latitude").getAsDouble();
    }

    private static double getLongitude(JsonObject json) {
        return json.get("longitude").getAsDouble();
    }

    private static Commodity getCommodity(JsonObject json, PathfinderServices services) {
        JsonObject model = json.getAsJsonObject("commodity");
        return Commodity.getInstance(model, services);
    }

    public ActionStatus getStatus() {
        return this.status;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Commodity getCommodity() {
        return this.commodity;
    }

    public String toString() {
        JsonObject json = new JsonObject();
        json.addProperty("latitude", (Number)this.getLatitude());
        json.addProperty("longitude", (Number)this.getLongitude());
        json.addProperty("status", this.getStatus().toString());
        if (this.getCommodity() != null) {
            json.addProperty("model", this.getCommodity().getPathName());
        }
        return json.toString();
    }
}

