/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.Authenticator;
import xyz.thepathfinder.android.MessageHandler;

public class AuthenticationMessageHandler
implements MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationMessageHandler.class);
    private final Authenticator authenticator;
    private int receivedMessageCount;

    public AuthenticationMessageHandler(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.receivedMessageCount = 0;
    }

    public void onMessage(String message) {
        ++this.receivedMessageCount;
        JsonObject json = new JsonParser().parse(message).getAsJsonObject();
        if (!json.has("message")) {
            logger.warn("Ignoring invalid message: " + json.toString());
            return;
        }
        String type = json.get("message").getAsString();
        logger.info("Received message of type: " + type);
        this.authenticator.notifyUpdate(type, json);
    }

    @Override
    public int getReceivedMessageCount() {
        return this.receivedMessageCount;
    }
}

