/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.ClusterListener;
import xyz.thepathfinder.android.CommodityListener;
import xyz.thepathfinder.android.CommodityStatus;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Route;
import xyz.thepathfinder.android.SubscribableCrudModel;
import xyz.thepathfinder.android.Transport;

public class Commodity
extends SubscribableCrudModel<Commodity, CommodityListener> {
    private static final Logger logger = LoggerFactory.getLogger(Commodity.class);
    private double startLatitude;
    private double startLongitude;
    private double endLatitude;
    private double endLongitude;
    private CommodityStatus status;
    private JsonObject metadata;
    private Long transportId;
    private Route route;
    private String createCluster;

    private Commodity(String path, PathfinderServices services) {
        super(path, ModelType.COMMODITY, services);
        logger.info("Constructing commodity by path: " + path);
        boolean isRegistered = this.getServices().getRegistry().isModelRegistered(new Path(path, ModelType.COMMODITY));
        if (isRegistered) {
            logger.error("Illegal Argument Exception: Commodity path already exists " + path);
            throw new IllegalArgumentException("Commodity path already exists: " + path);
        }
        if (path != null) {
            this.getServices().getRegistry().registerModel(this);
        }
        this.startLatitude = 0.0;
        this.startLongitude = 0.0;
        this.endLatitude = 0.0;
        this.endLongitude = 0.0;
        this.status = CommodityStatus.INACTIVE;
        this.metadata = new JsonObject();
        this.transportId = null;
        this.route = null;
        this.createCluster = null;
    }

    private Commodity(String path, double startLatitude, double startLongitude, double endLatitude, double endLongitude, CommodityStatus status, JsonObject metadata, Long transportId, PathfinderServices services) {
        this(path, services);
        logger.info("Constructing commodity by parameters: " + path);
        this.startLatitude = startLatitude;
        this.startLongitude = startLongitude;
        this.endLatitude = endLatitude;
        this.endLongitude = endLongitude;
        this.status = status == null ? CommodityStatus.INACTIVE : status;
        this.metadata = metadata == null ? new JsonObject() : metadata;
        this.transportId = transportId;
        this.route = null;
    }

    protected static Commodity getInstance(String path, PathfinderServices services) {
        Commodity commodity = (Commodity)services.getRegistry().getModel(new Path(path, ModelType.COMMODITY));
        if (commodity == null && Path.isValidPath(path)) {
            return new Commodity(path, services);
        }
        logger.info("Finished getting commodity instance: " + commodity);
        return commodity;
    }

    protected static Commodity getInstance(JsonObject commodityJson, PathfinderServices services) {
        if (!Commodity.checkCommodityFields(commodityJson)) {
            logger.error("Illegal Argument Exception: JSON could not be parse to a commodity " + commodityJson);
            throw new IllegalArgumentException("JSON could not be parsed to a commodity " + commodityJson);
        }
        String path = Commodity.getPath(commodityJson);
        Commodity commodity = Commodity.getInstance(path, services);
        logger.info("Notifying commodity of update: \nCurrent commodity: " + commodity + "\nNew JSON: " + commodityJson);
        commodity.notifyUpdate((String)null, commodityJson);
        return commodity;
    }

    private static boolean checkCommodityField(JsonObject commodityJson, String field) {
        return commodityJson.has(field);
    }

    private static boolean checkCommodityFields(JsonObject commodityJson) {
        return Commodity.checkCommodityField(commodityJson, "id") && Commodity.checkCommodityField(commodityJson, "clusterId") && Commodity.checkCommodityField(commodityJson, "startLatitude") && Commodity.checkCommodityField(commodityJson, "startLongitude") && Commodity.checkCommodityField(commodityJson, "endLatitude") && Commodity.checkCommodityField(commodityJson, "endLongitude") && Commodity.checkCommodityField(commodityJson, "status") && Commodity.checkCommodityField(commodityJson, "metadata") && commodityJson.get("metadata").isJsonObject();
    }

    private static String getPath(JsonObject commodityJson) {
        String path = commodityJson.get("clusterId").getAsString();
        return path + "/" + commodityJson.get("id").getAsString();
    }

    private static CommodityStatus getStatus(String status) {
        return CommodityStatus.getStatus(status);
    }

    @Override
    protected JsonObject createValueJson() {
        JsonObject json = new JsonObject();
        json.addProperty("clusterId", this.createCluster);
        json.addProperty("model", this.getModelType().toString());
        json.addProperty("startLatitude", (Number)this.getStartLatitude());
        json.addProperty("startLongitude", (Number)this.getStartLongitude());
        json.addProperty("endLatitude", (Number)this.getEndLatitude());
        json.addProperty("endLongitude", (Number)this.getEndLongitude());
        json.addProperty("status", this.getStatus().toString());
        json.add("metadata", (JsonElement)this.getMetadata());
        return json;
    }

    protected void initCommodity(double startLatitude, double startLongitude, double endLatitude, double endLongitude, CommodityStatus status, JsonObject metadata, String cluster) {
        this.startLatitude = startLatitude;
        this.startLongitude = startLongitude;
        this.endLatitude = endLatitude;
        this.endLongitude = endLongitude;
        this.status = status;
        this.metadata = metadata;
        this.createCluster = cluster;
    }

    public void updateStartLocation(double startLatitude, double startLongitude) {
        this.update(startLatitude, startLongitude, null, null, null, null, null);
    }

    public double getStartLatitude() {
        return this.startLatitude;
    }

    private void setStartLatitude(double latitude) {
        this.startLatitude = latitude;
    }

    public double getStartLongitude() {
        return this.startLongitude;
    }

    private void setStartLongitude(double longitude) {
        this.startLongitude = longitude;
    }

    public void updateEndLocation(double endLatitude, double endLongitude) {
        this.update(null, null, endLatitude, endLongitude, null, null, null);
    }

    public double getEndLatitude() {
        return this.endLatitude;
    }

    private void setEndLatitude(double latitude) {
        this.endLatitude = latitude;
    }

    public double getEndLongitude() {
        return this.endLongitude;
    }

    private void setEndLongitude(double longitude) {
        this.endLongitude = longitude;
    }

    public CommodityStatus getStatus() {
        return this.status;
    }

    private void setStatus(String status) {
        this.setStatus(Commodity.getStatus(status));
    }

    private void setStatus(CommodityStatus status) {
        if (status == null) {
            logger.error("Illegal Argument Exception illegal commodity status: " + (Object)((Object)status));
            throw new IllegalArgumentException("Illegal commodity status: " + (Object)((Object)status));
        }
        this.status = status;
    }

    public void updateStatus(CommodityStatus status) {
        this.update(null, null, null, null, status, null, null);
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    private void setMetadata(JsonObject metadata) {
        this.metadata = metadata == null ? new JsonObject() : metadata;
    }

    public void updateMetadata(JsonObject metadata) {
        this.update(null, null, null, null, null, metadata, null);
    }

    public Route getRoute() {
        return this.route;
    }

    private void setRoute(Route route) {
        this.route = route;
    }

    public Transport getTransport() {
        Long transportId = this.getTransportId();
        if (transportId == null) {
            return null;
        }
        return Transport.getInstance(this.getParentPath().getPathName() + transportId, this.getServices());
    }

    private Long getTransportId() {
        return this.transportId;
    }

    private void setTransportId(Long transportId) {
        this.transportId = transportId;
    }

    public void updatePickedUp(Transport transport) {
        Long id = Long.parseLong(transport.getName());
        this.update(null, null, null, null, CommodityStatus.PICKED_UP, null, id);
    }

    public void updateDroppedOff() {
        this.update(null, null, null, null, CommodityStatus.DROPPED_OFF, null, null);
    }

    public void update(Double startLatitude, Double startLongitude, Double endLatitude, Double endLongitude, CommodityStatus status, JsonObject metadata, Long transportId) {
        JsonObject value = new JsonObject();
        if (startLatitude != null) {
            value.addProperty("startLatitude", (Number)startLatitude);
        }
        if (startLongitude != null) {
            value.addProperty("startLongitude", (Number)startLongitude);
        }
        if (endLatitude != null) {
            value.addProperty("endLatitude", (Number)endLatitude);
        }
        if (endLongitude != null) {
            value.addProperty("endLongitude", (Number)endLongitude);
        }
        if (status != null) {
            value.addProperty("status", status.toString());
        }
        if (metadata != null) {
            value.add("metadata", (JsonElement)metadata);
        }
        if (transportId != null) {
            value.addProperty("transportId", (Number)transportId);
        }
        super.update(value);
    }

    @Override
    protected boolean updateFields(JsonObject json) {
        boolean updated = false;
        double prevStartLatitude = this.getStartLatitude();
        if (json.has("startLatitude")) {
            this.setStartLatitude(json.get("startLatitude").getAsDouble());
        }
        double prevStartLongitude = this.getStartLongitude();
        if (json.has("startLongitude")) {
            this.setStartLongitude(json.get("startLongitude").getAsDouble());
        }
        double prevEndLatitude = this.getEndLatitude();
        if (json.has("endLatitude")) {
            this.setEndLatitude(json.get("endLatitude").getAsDouble());
        }
        double prevEndLongitude = this.getEndLongitude();
        if (json.has("endLongitude")) {
            this.setEndLongitude(json.get("endLongitude").getAsDouble());
        }
        CommodityStatus prevStatus = this.getStatus();
        if (json.has("status")) {
            this.setStatus(Commodity.getStatus(json.get("status").getAsString()));
        }
        JsonObject prevMetadata = this.getMetadata();
        if (json.has("metadata")) {
            this.setMetadata(json.get("metadata").getAsJsonObject());
        }
        Long prevTransportId = this.getTransportId();
        if (json.has("transportId")) {
            this.setTransportId(json.get("transportId").getAsLong());
        } else {
            this.setTransportId(null);
        }
        List listeners = this.getListeners();
        if (this.getStartLatitude() != prevStartLatitude || this.getStartLongitude() != prevStartLongitude) {
            logger.info("Commodity " + this.getPathName() + " start location updated: " + this.getStartLatitude() + "," + this.getStartLongitude());
            for (CommodityListener listener : listeners) {
                listener.startLocationUpdated(this.getStartLatitude(), this.getStartLongitude());
            }
            updated = true;
        }
        if (this.getEndLatitude() != prevEndLatitude || this.getEndLongitude() != prevEndLongitude) {
            logger.info("Commodity " + this.getPathName() + " end location updated: " + this.getEndLatitude() + "," + this.getEndLongitude());
            for (CommodityListener listener : listeners) {
                listener.endLocationUpdated(this.getEndLatitude(), this.getEndLongitude());
            }
            updated = true;
        }
        if (!this.getStatus().equals((Object)prevStatus)) {
            logger.info("Commodity " + this.getPathName() + " status updated: " + (Object)((Object)this.getStatus()));
            for (CommodityListener listener : listeners) {
                listener.statusUpdated(this.getStatus());
            }
            updated = true;
        }
        if (!this.getMetadata().equals((Object)prevMetadata)) {
            logger.info("Commodity " + this.getPathName() + " metadata updated: " + this.getMetadata());
            for (CommodityListener listener : listeners) {
                listener.metadataUpdated(this.getMetadata());
            }
            updated = true;
        }
        if (this.getTransportId() != null && !this.getTransportId().equals(prevTransportId)) {
            logger.info("Commodity " + this.getPathName() + " transport updated: " + this.getTransportId());
            Transport transport = this.getTransport();
            for (CommodityListener listener : listeners) {
                listener.transportUpdated(transport);
            }
            updated = true;
        }
        Path parentPath = this.getParentPath();
        if (updated && this.getServices().getRegistry().isModelRegistered(parentPath)) {
            boolean added;
            Cluster parentCluster = Cluster.getInstance(parentPath.getPathName(), this.getServices());
            boolean bl = added = !parentCluster.getCommoditiesMap().containsKey(this.getPathName());
            if (added) {
                parentCluster.addCommodity(this);
            }
            Collection<Commodity> commodities = parentCluster.getCommodities();
            logger.info("Commodity " + this.getPathName() + " calling parent cluster's update");
            List clusterListeners = parentCluster.getListeners();
            for (ClusterListener listener : clusterListeners) {
                if (added) {
                    listener.commodityAdded(this);
                }
                listener.commodityUpdated(this);
                listener.commoditiesUpdated(commodities);
            }
        }
        return updated;
    }

    @Override
    protected void route(JsonObject json, PathfinderServices services) {
        JsonObject route = json.getAsJsonObject("value");
        logger.info("Commodity setting route: " + this.getPathName());
        this.setRoute(new Route(route, services));
        logger.info("Commodity updating route: " + this.getPathName());
        for (CommodityListener listener : this.getListeners()) {
            listener.routed(this.getRoute());
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("path", this.getPathName());
        json.addProperty("model", this.getModelType().toString());
        json.addProperty("startLatitude", (Number)this.getStartLatitude());
        json.addProperty("startLongitude", (Number)this.getStartLongitude());
        json.addProperty("endLatitude", (Number)this.getEndLatitude());
        json.addProperty("endLongitude", (Number)this.getEndLongitude());
        json.addProperty("status", this.getStatus().toString());
        json.add("metadata", (JsonElement)this.getMetadata());
        if (this.getRoute() != null) {
            json.addProperty("route", this.getRoute().toString());
        }
        return json;
    }

    public String toString() {
        return this.toJson().toString();
    }

    @Override
    protected Commodity getThis() {
        return this;
    }
}

