/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.AuthenticationMessageHandler;
import xyz.thepathfinder.android.MessageHandler;

class Connection
extends Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private Session session;
    private long sentMessageCount = 0L;
    private MessageHandler messageHandler;
    private Queue<String> messageQueue = new LinkedList<String>();

    protected Connection() {
    }

    protected void setMessageHandler(MessageHandler messageHandler) {
        if (this.session != null) {
            this.session.removeMessageHandler((javax.websocket.MessageHandler)this.messageHandler);
            this.session.addMessageHandler((javax.websocket.MessageHandler)messageHandler);
        }
        this.messageHandler = messageHandler;
        if (this.session != null && !(this.messageHandler instanceof AuthenticationMessageHandler)) {
            logger.info("Sending stored messages");
            for (String message : this.messageQueue) {
                this.send(message);
            }
            logger.info("End sending stored messages");
            this.messageQueue.clear();
        }
    }

    private void send(String message) {
        logger.info("Sending json to Pathfinder: " + message);
        this.session.getAsyncRemote().sendText(message);
        ++this.sentMessageCount;
    }

    public void sendMessage(String message) {
        if (this.isConnected()) {
            this.send(message);
        } else {
            logger.warn("Attempting to send message while websocket is not open. Storing message until connection opens: " + message);
            this.messageQueue.add(message);
        }
    }

    protected void sendAuthenticationMessage(String message) {
        this.send(message);
    }

    public void onOpen(Session session, EndpointConfig config) {
        logger.info("Pathfinder connection opened");
        this.session = session;
        this.session.addMessageHandler((javax.websocket.MessageHandler)this.messageHandler);
        if (!(this.messageHandler instanceof AuthenticationMessageHandler)) {
            logger.info("Sending stored messages");
            for (String message : this.messageQueue) {
                this.send(message);
            }
            logger.info("End sending stored messages");
            this.messageQueue.clear();
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        logger.info("Pathfinder connection closed: " + closeReason);
        this.session = session;
    }

    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    protected long getSentMessageCount() {
        return this.sentMessageCount;
    }

    protected long getReceivedMessageCount() {
        return this.messageHandler.getReceivedMessageCount();
    }

    public void close(CloseReason reason) throws IOException {
        this.session.close(reason);
    }
}

