/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.Listenable;
import xyz.thepathfinder.android.ModelListener;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;
import xyz.thepathfinder.android.PathfinderServices;

public abstract class Model<T extends Model<T, E>, E extends ModelListener<T>>
extends Listenable<E, JsonObject> {
    private static final Logger logger = LoggerFactory.getLogger(Model.class);
    private final Path path;
    private final PathfinderServices services;
    private boolean isConnected;
    private Queue<JsonObject> messageBacklog;

    public Model(String path, ModelType type, PathfinderServices services) {
        this.path = new Path(path, type);
        this.services = services;
        this.isConnected = false;
        if (path == null) {
            this.messageBacklog = new LinkedList<JsonObject>();
        }
    }

    protected Path getPath() {
        return this.path;
    }

    public boolean isPathUnknown() {
        return this.path.getPathName() == null;
    }

    public String getPathName() {
        return this.path.getPathName();
    }

    protected void setPathName(String path) {
        if (this.isPathUnknown()) {
            logger.info("Setting path to: " + path);
            this.path.setPathName(path);
            this.getServices().getRegistry().registerModel(this);
            logger.info("Flushing " + this.getPathName() + "'s message backlog");
            for (JsonObject json : this.messageBacklog) {
                json.addProperty("id", (Number)Integer.parseInt(this.getName()));
                this.getServices().getConnection().sendMessage(json.toString());
            }
        } else {
            logger.error("Illegal State Exception: The path of a model may not be set after becoming known");
            throw new IllegalStateException("The path of a model may not be set after becoming known");
        }
        logger.info("End flushing backlog");
        this.messageBacklog = null;
    }

    protected Path getChildPath(String name, ModelType type) {
        return this.path.getChildPath(name, type);
    }

    public Path getParentPath() {
        return this.path.getParentPath();
    }

    public String getName() {
        return this.path.getName();
    }

    public Cluster getParentCluster() {
        Path parentPath = this.getParentPath();
        return Cluster.getInstance(parentPath.getPathName(), this.services);
    }

    public ModelType getModelType() {
        return this.path.getModelType();
    }

    protected PathfinderServices getServices() {
        return this.services;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    protected void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    private boolean updateType(String reason, JsonObject json) {
        boolean updated = false;
        JsonObject value = null;
        logger.info("Reason for update is: " + reason + ", " + json);
        if (json.has("value") && !json.has("route")) {
            value = json.getAsJsonObject("value");
        } else if (reason == null) {
            value = json;
        }
        logger.info("Value is: " + value);
        if (value != null) {
            updated = this.updateFields(value);
        }
        logger.info("Finished updating " + this.getPathName() + "'s fields.");
        List listeners = this.getListeners();
        if (updated && !"Updated".equals(reason)) {
            logger.info("Model " + this.getPathName() + " updated");
            for (ModelListener listener : listeners) {
                logger.info("Calling updated");
                listener.updated(this.getThis());
                logger.info("Finished Calling updated");
            }
        }
        logger.info("Reason: " + reason);
        if (reason == null) {
            return updated;
        }
        if (reason.equals("Updated")) {
            logger.info("Model " + this.getPathName() + " updated");
            for (ModelListener listener : listeners) {
                listener.updated(this.getThis());
            }
            return updated;
        }
        if (reason.equals("Routed")) {
            logger.info("Model " + this.getPathName() + " routed");
            this.route(json, this.getServices());
            return true;
        }
        if (reason.equals("Model")) {
            logger.info("Model " + this.getPathName() + " connected");
            for (ModelListener listener : listeners) {
                listener.connected(this.getThis());
            }
            return updated;
        }
        if (reason.equals("Subscribed")) {
            logger.info("Model " + this.getPathName() + " subscribed");
            for (ModelListener listener : listeners) {
                listener.subscribed(this.getThis());
            }
            return updated;
        }
        if (reason.equals("RouteSubscribed")) {
            logger.info("Model " + this.getPathName() + " route subscribed");
            for (ModelListener listener : listeners) {
                listener.routeSubscribed(this.getThis());
            }
            return updated;
        }
        if (reason.equals("Unsubscribed")) {
            logger.info("Model " + this.getPathName() + " unsubscribed");
            for (ModelListener listener : listeners) {
                listener.unsubscribed(this.getThis());
            }
            return updated;
        }
        if (reason.equals("RouteUnsubscribed")) {
            logger.info("Model " + this.getPathName() + " route unsubscribed");
            for (ModelListener listener : listeners) {
                listener.routeUnsubscribed(this.getThis());
            }
            return updated;
        }
        if (reason.equals("Created")) {
            logger.info("Model " + this.getPathName() + " created");
            for (ModelListener listener : listeners) {
                listener.created(this.getThis());
            }
            return updated;
        }
        if (reason.equals("Deleted")) {
            logger.info("Model " + this.getPathName() + " deleted");
            for (ModelListener listener : listeners) {
                this.setConnected(false);
                listener.deleted(this.getThis());
            }
            return updated;
        }
        if (reason.equals("Error") && value != null) {
            logger.warn("Model " + this.getPathName() + " received error: " + value.get("reason").getAsString());
            for (ModelListener listener : listeners) {
                listener.error(value.get("reason").getAsString());
            }
            return updated;
        }
        logger.warn("Invalid message sent to " + this.getPathName() + " with type: " + reason + "\nJson: " + json);
        return updated;
    }

    @Override
    protected boolean notifyUpdate(String reason, JsonObject json) {
        if (!this.isPathUnknown()) {
            this.setConnected(true);
        }
        return this.updateType(reason, json);
    }

    protected void sendMessage(JsonObject json) {
        if (!this.isPathUnknown()) {
            this.getServices().getConnection().sendMessage(json.toString());
        } else {
            this.messageBacklog.offer(json);
        }
    }

    public abstract JsonObject toJson();

    protected abstract boolean updateFields(JsonObject var1);

    protected abstract void route(JsonObject var1, PathfinderServices var2);

    protected abstract T getThis();
}

