/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.MessageHandler;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Transport;

class ModelMessageHandler
implements MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(MessageHandler.class);
    private PathfinderServices services;
    private int receivedMessageCount;

    protected ModelMessageHandler(PathfinderServices services) {
        this.services = services;
        this.receivedMessageCount = 0;
    }

    public void onMessage(String message) {
        try {
            logger.info("Received json: " + message);
            ++this.receivedMessageCount;
            JsonObject json = new JsonParser().parse(message).getAsJsonObject();
            if (!json.has("message") || !json.has("model")) {
                logger.warn("Ignoring invalid message: " + json.toString());
            } else {
                String type = json.get("message").getAsString();
                JsonObject value = json.getAsJsonObject("value");
                ModelType modelType = ModelType.getModelType(json.get("model").getAsString());
                logger.info("Model Type : " + (Object)((Object)modelType));
                Path path = new Path(this.getPath(json), modelType);
                Model model = this.services.getRegistry().getModel(path);
                if (model == null && type.equals("Created") && ModelType.CLUSTER != modelType && (model = this.services.getRegistry().findInCreateBacklog(value, modelType)) != null) {
                    this.services.getRegistry().removeCreateBacklog(model);
                    model.setPathName(path.getPathName());
                }
                if (model != null) {
                    logger.info("Notifying " + model.getPathName() + " Type: " + (Object)((Object)model.getModelType()) + " of message");
                    model.notifyUpdate(type, json);
                } else {
                    Path parentPath = path.getParentPath();
                    if (parentPath != null && this.services.getRegistry().isModelRegistered(parentPath)) {
                        if (modelType == ModelType.CLUSTER) {
                            Cluster.getInstance(value, this.services);
                            return;
                        }
                        if (modelType == ModelType.COMMODITY) {
                            Commodity.getInstance(value, this.services);
                            return;
                        }
                        if (modelType == ModelType.TRANSPORT) {
                            Transport.getInstance(value, this.services);
                            return;
                        }
                    }
                    logger.warn("Received message that couldn't be routed to a model: " + message);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private String getPath(JsonObject json) {
        JsonObject value = json.getAsJsonObject("value");
        String path = "";
        if (json.has("id")) {
            path = path + json.get("id").getAsString();
        } else if (json.has("clusterId")) {
            path = path + json.get("clusterId").getAsString();
        } else if (!json.get("model").getAsString().equals(ModelType.CLUSTER.toString())) {
            path = path + value.get("clusterId").getAsString();
            path = path + "/" + value.get("id").getAsString();
        } else {
            path = path + value.get("id").getAsString();
        }
        return path;
    }

    @Override
    public int getReceivedMessageCount() {
        return this.receivedMessageCount;
    }
}

