/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;

class ModelRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ModelRegistry.class);
    private final Map<Path, Model> models = new HashMap<Path, Model>();
    private final List<Model> createBacklog = new ArrayList<Model>();

    protected ModelRegistry() {
    }

    protected void registerModel(Model model) {
        if (this.models.containsKey(model.getPath())) {
            logger.error("Illegal State Exception: path already exists" + model.getPathName());
            throw new IllegalStateException("Path already exists: " + model.getPathName());
        }
        if (model.isPathUnknown()) {
            logger.error("Illegal Argument Exception: Cannot register a model with an unknown path.");
            throw new IllegalArgumentException("Cannot register a model with an unknown path.");
        }
        this.models.put(model.getPath(), model);
    }

    protected Model unregisterModel(Path path) {
        return this.models.remove(path);
    }

    protected boolean isModelRegistered(Path path) {
        return this.models.containsKey(path);
    }

    protected Model getModel(Path path) {
        logger.info("Model requested: " + path.getPathName() + " Type: " + (Object)((Object)path.getModelType()));
        return this.models.get(path);
    }

    protected void addCreateBacklog(Model model) {
        this.createBacklog.add(model);
    }

    protected void removeCreateBacklog(Model model) {
        this.createBacklog.remove(model);
    }

    protected Model findInCreateBacklog(JsonObject json, ModelType type) {
        long id = json.remove("id").getAsLong();
        String clusterId = json.remove("clusterId").getAsString();
        json.addProperty("path", (String)null);
        for (Model model : this.createBacklog) {
            JsonObject modelJson = model.toJson();
            modelJson.remove("model");
            if (model.getModelType() != type || !json.equals((Object)modelJson)) continue;
            json.remove("path");
            json.addProperty("id", (Number)id);
            json.addProperty("clusterId", clusterId);
            return model;
        }
        json.remove("path");
        json.addProperty("id", (Number)id);
        json.addProperty("clusterId", clusterId);
        return null;
    }
}

