/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.ModelType;

class Path {
    protected static final String DEFAULT_PATH = "/root";
    private static final Logger logger = LoggerFactory.getLogger(Path.class);
    private static final String PATH_SEPARATOR = "/";
    private final ModelType modelType;
    private String path;

    protected Path(String path, ModelType modelType) {
        if (!Path.isValidPath(path)) {
            logger.error("Illegal Argument Exception: Illegal path name " + path);
            throw new IllegalArgumentException("Illegal path name " + path);
        }
        this.path = path;
        this.modelType = modelType;
    }

    public static boolean isValidPath(String path) {
        return path == null || !path.equals("") && !path.contains(" ");
    }

    public static boolean isValidName(String name) {
        return name != null && !name.contains(PATH_SEPARATOR) && !name.equals("") && !name.contains(" ");
    }

    protected Path getChildPath(String name, ModelType type) {
        if (!this.getModelType().equals((Object)ModelType.CLUSTER) || !type.equals((Object)ModelType.CLUSTER)) {
            logger.error("Illegal State Exception: Cannot get a child path name on a non-cluster type");
            throw new IllegalStateException("Cannot get a child path name on a non-cluster type");
        }
        if (this.path == null) {
            logger.error("Illegal State Exception: Cannot get a child path with an unknown path, make sure the model has been created.");
            throw new IllegalStateException("Cannot get a child path with an unknown path, make sure the model has been created.");
        }
        if (Path.isValidName(name)) {
            return new Path(this.path + PATH_SEPARATOR + name, type);
        }
        logger.error("Illegal Argument Exception: Illegal path name " + name);
        throw new IllegalArgumentException("Illegal path name: " + name);
    }

    public String getName() {
        if (this.path == null) {
            return null;
        }
        int lastSlashIndex = this.path.lastIndexOf(PATH_SEPARATOR) + 1;
        return this.path.substring(lastSlashIndex);
    }

    public String getPathName() {
        return this.path;
    }

    protected void setPathName(String path) {
        if (this.path != null) {
            logger.error("Illegal State Exception: The path of a model may not be set after becoming known");
            throw new IllegalStateException("The path of a model may not be set after becoming known");
        }
        this.path = path;
    }

    public Path getParentPath() {
        if (this.path == null) {
            return null;
        }
        int lastSlashIndex = this.path.lastIndexOf(PATH_SEPARATOR);
        if (lastSlashIndex <= 0) {
            return null;
        }
        return new Path(this.path.substring(0, lastSlashIndex), ModelType.CLUSTER);
    }

    public ModelType getModelType() {
        return this.modelType;
    }

    public boolean equals(Object o) {
        if (o instanceof Path) {
            Path otherPath = (Path)o;
            return this.modelType == otherPath.modelType && (this.path == null && otherPath.path == null || this.path != null && this.path.equals(otherPath.path));
        }
        return false;
    }

    public int hashCode() {
        if (this.path == null) {
            return 0;
        }
        return this.path.hashCode();
    }
}

