/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import org.glassfish.tyrus.client.ClientManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.AuthenticationListener;
import xyz.thepathfinder.android.AuthenticationMessageHandler;
import xyz.thepathfinder.android.Authenticator;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.Connection;
import xyz.thepathfinder.android.ModelRegistry;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Transport;

public class Pathfinder {
    private static final Logger logger = LoggerFactory.getLogger(Pathfinder.class);
    private static final String DEFAULT_AUTH_URI = "http://auth.thepathfinder.xyz/connection";
    private static final String DEFAULT_WEBSOCKET_URI = "ws://api.thepathfinder.xyz/socket";
    private final String applicationIdentifier;
    private Authenticator authenticator;
    private PathfinderServices services;
    private URI webSocketUrl;

    public Pathfinder(String applicationIdentifier, String userCredentials) {
        try {
            this.webSocketUrl = new URI(DEFAULT_WEBSOCKET_URI);
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage());
        }
        this.applicationIdentifier = applicationIdentifier;
        this.constructPathfinderServices(applicationIdentifier, userCredentials, DEFAULT_AUTH_URI);
    }

    public Pathfinder(String applicationIdentifier, String userCredentials, String authenticationServerURL) {
        try {
            this.webSocketUrl = new URI(DEFAULT_WEBSOCKET_URI);
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage());
        }
        this.applicationIdentifier = applicationIdentifier;
        this.constructPathfinderServices(applicationIdentifier, userCredentials, authenticationServerURL);
    }

    protected Pathfinder(String applicationIdentifier, String userCredentials, URI webSocketUrl) {
        this.applicationIdentifier = applicationIdentifier;
        this.webSocketUrl = webSocketUrl;
        this.constructPathfinderServices(applicationIdentifier, userCredentials, DEFAULT_AUTH_URI);
    }

    private void constructPathfinderServices(String applicationIdentifier, String userCredentials, String authenticationServerURL) {
        Connection connection = new Connection();
        ModelRegistry registry = new ModelRegistry();
        this.services = new PathfinderServices(registry, connection);
        this.authenticator = new Authenticator(applicationIdentifier, userCredentials, authenticationServerURL, this.services);
        AuthenticationMessageHandler messageHandler = new AuthenticationMessageHandler(this.authenticator);
        connection.setMessageHandler(messageHandler);
    }

    public void connect() {
        if (!this.isConnected()) {
            ClientManager clientManager = new ClientManager();
            ClientEndpointConfig.Configurator configurator = new ClientEndpointConfig.Configurator(){

                public void beforeRequest(Map<String, List<String>> header) {
                    header.put("Authorization", Collections.singletonList(Pathfinder.this.applicationIdentifier));
                }
            };
            ClientEndpointConfig configuration = ClientEndpointConfig.Builder.create().configurator(configurator).build();
            try {
                clientManager.asyncConnectToServer((Endpoint)this.services.getConnection(), configuration, this.webSocketUrl);
            }
            catch (DeploymentException e) {
                logger.error("Deployment Exception: " + e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    public void addAuthenticationListener(AuthenticationListener listener) {
        this.authenticator.addListener(listener);
    }

    public Cluster getDefaultCluster() {
        return Cluster.getInstance("/root", this.services);
    }

    public Cluster getCluster(String path) {
        return Cluster.getInstance(path, this.services);
    }

    public Commodity getCommodity(String path) {
        return Commodity.getInstance(path, this.services);
    }

    public Transport getTransport(String path) {
        return Transport.getInstance(path, this.services);
    }

    public boolean isConnected() {
        return this.services.getConnection().isConnected();
    }

    protected long getSentMessageCount() {
        return this.services.getConnection().getSentMessageCount();
    }

    protected long getReceivedMessageCount() {
        return this.services.getConnection().getReceivedMessageCount();
    }

    public void close() throws IOException {
        CloseReason reason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Connection ended by user");
        this.close(reason);
    }

    public void close(CloseReason reason) throws IOException {
        if (this.isConnected()) {
            logger.info("Connection closed");
            this.services.getConnection().close(reason);
        }
    }
}

