/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.ModelListener;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.SubscribableModel;

public abstract class SubscribableCrudModel<T extends SubscribableCrudModel<T, E>, E extends ModelListener<T>>
extends SubscribableModel<T, E> {
    private static final Logger logger = LoggerFactory.getLogger(SubscribableCrudModel.class);

    public SubscribableCrudModel(String path, ModelType type, PathfinderServices services) {
        super(path, type, services);
    }

    public void connect() {
        JsonObject json = this.getMessageHeader("Read");
        this.sendMessage(json);
    }

    public void create() {
        if (this.isConnected()) {
            logger.warn("Cannot create connected model " + this.getPathName() + " the model already exists, ignoring request.");
            return;
        }
        JsonObject value = this.createValueJson();
        JsonObject json = this.getMessageHeader("Create");
        json.addProperty("model", value.get("model").getAsString());
        json.add("value", (JsonElement)value);
        if (this.isPathUnknown()) {
            this.getServices().getRegistry().addCreateBacklog(this);
        }
        this.getServices().getConnection().sendMessage(json.toString());
    }

    public void delete() {
        JsonObject json = this.getMessageHeader("Delete");
        this.sendMessage(json);
    }

    protected void update(JsonObject value) {
        JsonObject json = this.getMessageHeader("Update");
        json.add("value", (JsonElement)value);
        this.sendMessage(json);
    }

    protected abstract JsonObject createValueJson();
}

