/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.ModelListener;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.PathfinderServices;

public abstract class SubscribableModel<T extends SubscribableModel<T, E>, E extends ModelListener<T>>
extends Model<T, E> {
    private static final Logger logger = LoggerFactory.getLogger(SubscribableModel.class);

    public SubscribableModel(String path, ModelType type, PathfinderServices services) {
        super(path, type, services);
    }

    public JsonObject getMessageHeader(String type) {
        JsonObject json = new JsonObject();
        json.addProperty("message", type);
        if (this.getModelType() == ModelType.CLUSTER) {
            json.addProperty("id", this.getPathName());
        } else if (!this.isPathUnknown()) {
            json.addProperty("id", (Number)Integer.parseInt(this.getName()));
        }
        json.addProperty("model", this.getModelType().toString());
        return json;
    }

    private void sendSubscribeMessage(String type) {
        JsonObject json = this.getMessageHeader(type);
        if (this.getModelType().equals((Object)ModelType.CLUSTER)) {
            json.remove("id");
            json.addProperty("model", ModelType.TRANSPORT.toString());
            json.addProperty("clusterId", this.getPathName());
            this.sendMessage(json);
            json.addProperty("model", ModelType.COMMODITY.toString());
            this.sendMessage(json);
        } else {
            this.sendMessage(json);
        }
    }

    public void subscribe() {
        this.sendSubscribeMessage("Subscribe");
    }

    public void unsubscribe() {
        this.sendSubscribeMessage("Unsubscribe");
    }

    public void routeSubscribe() {
        JsonObject json = this.getMessageHeader("RouteSubscribe");
        this.sendMessage(json);
    }

    public void routeUnsubscribe() {
        JsonObject json = this.getMessageHeader("RouteUnsubscribe");
        this.sendMessage(json);
    }
}

