/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.ClusterListener;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.ModelType;
import xyz.thepathfinder.android.Path;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Route;
import xyz.thepathfinder.android.SubscribableCrudModel;
import xyz.thepathfinder.android.TransportListener;
import xyz.thepathfinder.android.TransportStatus;

public class Transport
extends SubscribableCrudModel<Transport, TransportListener> {
    private static final Logger logger = LoggerFactory.getLogger(Transport.class);
    private double latitude;
    private double longitude;
    private TransportStatus status;
    private JsonObject metadata;
    private List<Commodity> commodities;
    private Route route;
    private String createCluster;

    private Transport(String path, PathfinderServices services) {
        super(path, ModelType.TRANSPORT, services);
        logger.info("Constructing transport by parameters: " + path);
        boolean isRegistered = this.getServices().getRegistry().isModelRegistered(new Path(path, ModelType.TRANSPORT));
        if (isRegistered) {
            logger.error("Illegal Argument Exception: Transport path already exists: " + path);
            throw new IllegalArgumentException("Transport path already exists: " + path);
        }
        if (path != null) {
            this.getServices().getRegistry().registerModel(this);
        }
        this.latitude = 0.0;
        this.longitude = 0.0;
        this.status = TransportStatus.OFFLINE;
        this.metadata = new JsonObject();
        this.commodities = new ArrayList<Commodity>();
        this.route = null;
        this.createCluster = null;
    }

    private Transport(String path, double latitude, double longitude, TransportStatus status, JsonObject metadata, List<Commodity> commodities, PathfinderServices services) {
        this(path, services);
        this.latitude = latitude;
        this.longitude = longitude;
        this.status = status == null ? TransportStatus.OFFLINE : status;
        this.metadata = metadata == null ? new JsonObject() : metadata;
        this.commodities = commodities;
        this.route = null;
    }

    public static Transport getInstance(String path, PathfinderServices services) {
        Transport transport = (Transport)services.getRegistry().getModel(new Path(path, ModelType.TRANSPORT));
        if (transport == null && Path.isValidPath(path)) {
            return new Transport(path, services);
        }
        logger.info("Finished getting transport instance: " + transport);
        return transport;
    }

    protected static Transport getInstance(JsonObject transportJson, PathfinderServices services) {
        if (!Transport.checkTransportFields(transportJson)) {
            logger.error("Illegal Argument Exception: Invalid JSON cannot be parsed to a transport " + transportJson);
            throw new IllegalArgumentException("Invalid JSON cannot be parsed to a transport " + transportJson);
        }
        String path = Transport.getPath(transportJson);
        Transport transport = Transport.getInstance(path, services);
        logger.info("Notifying transport of update: \nCurrent transport: " + transport + "\nNew JSON: " + transportJson);
        transport.notifyUpdate((String)null, transportJson);
        return transport;
    }

    private static boolean checkTransportField(JsonObject transportJson, String field) {
        return transportJson.has(field);
    }

    private static boolean checkTransportFields(JsonObject transportJson) {
        return Transport.checkTransportField(transportJson, "id") && Transport.checkTransportField(transportJson, "clusterId") && Transport.checkTransportField(transportJson, "latitude") && Transport.checkTransportField(transportJson, "longitude") && Transport.checkTransportField(transportJson, "status") && Transport.checkTransportField(transportJson, "metadata") && transportJson.get("metadata").isJsonObject() && Transport.checkTransportField(transportJson, "commodities") && transportJson.get("commodities").isJsonArray();
    }

    private static String getPath(JsonObject transportJson) {
        String path = transportJson.get("clusterId").getAsString();
        return path + "/" + transportJson.get("id").getAsString();
    }

    private static TransportStatus getStatus(String status) {
        return TransportStatus.getStatus(status);
    }

    @Override
    protected JsonObject createValueJson() {
        JsonObject json = new JsonObject();
        json.addProperty("clusterId", this.createCluster);
        json.addProperty("model", this.getModelType().toString());
        json.addProperty("latitude", (Number)this.getLatitude());
        json.addProperty("longitude", (Number)this.getLongitude());
        json.addProperty("status", this.getStatus().toString());
        json.add("metadata", (JsonElement)this.getMetadata());
        JsonArray commodities = new JsonArray();
        json.add("commodities", (JsonElement)commodities);
        return json;
    }

    protected void initTransport(double latitude, double longitude, TransportStatus status, JsonObject metadata, String cluster) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.status = status;
        this.metadata = metadata;
        this.createCluster = cluster;
    }

    public void updateLocation(double latitude, double longitude) {
        this.update(latitude, longitude, null, null);
    }

    public double getLatitude() {
        return this.latitude;
    }

    private void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    private void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public TransportStatus getStatus() {
        return this.status;
    }

    private void setStatus(TransportStatus status) {
        this.status = status;
    }

    public void updateStatus(TransportStatus status) {
        this.update(null, null, status, null);
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    private void setMetadata(JsonObject metadata) {
        this.metadata = metadata == null ? new JsonObject() : metadata;
    }

    public void updateMetadata(JsonObject metadata) {
        this.update(null, null, null, metadata);
    }

    public List<Commodity> getCommodities() {
        return Collections.unmodifiableList(this.commodities);
    }

    private void setCommodities(JsonArray json) {
        ArrayList<Commodity> commodities = new ArrayList<Commodity>();
        for (JsonElement commodityje : json) {
            Commodity commodity = Commodity.getInstance(commodityje.getAsJsonObject(), this.getServices());
            commodities.add(commodity);
        }
        this.commodities = commodities;
    }

    public Route getRoute() {
        return this.route;
    }

    protected void setRoute(Route route) {
        this.route = route;
    }

    public void update(Double latitude, Double longitude, TransportStatus status, JsonObject metadata) {
        JsonObject value = new JsonObject();
        if (latitude != null) {
            value.addProperty("latitude", (Number)latitude);
        }
        if (longitude != null) {
            value.addProperty("longitude", (Number)longitude);
        }
        if (status != null) {
            value.addProperty("status", status.toString());
        }
        if (metadata != null) {
            value.add("metadata", (JsonElement)metadata);
        }
        super.update(value);
    }

    @Override
    protected boolean updateFields(JsonObject json) {
        boolean updated = false;
        if (json.has("createCluster")) {
            this.createCluster = json.get("createCluster").getAsString();
        }
        double prevLatitude = this.getLatitude();
        if (json.has("latitude")) {
            this.setLatitude(json.get("latitude").getAsDouble());
        }
        double prevLongitude = this.getLongitude();
        if (json.has("longitude")) {
            this.setLongitude(json.get("longitude").getAsDouble());
        }
        TransportStatus prevStatus = this.getStatus();
        if (json.has("status")) {
            this.setStatus(Transport.getStatus(json.get("status").getAsString()));
        }
        JsonObject prevMetadata = this.getMetadata();
        if (json.has("metadata")) {
            this.setMetadata(json.getAsJsonObject("metadata"));
        }
        List<Commodity> prevCommodities = this.getCommodities();
        if (json.has("commodities")) {
            this.setCommodities(json.getAsJsonArray("commodities"));
        }
        List listeners = this.getListeners();
        if (this.getLatitude() != prevLatitude || this.getLongitude() != prevLongitude) {
            logger.info("Transport " + this.getPathName() + " location updated: " + this.getLatitude() + "," + this.getLongitude());
            for (TransportListener listener : listeners) {
                listener.locationUpdated(this.getLatitude(), this.getLongitude());
            }
            updated = true;
        }
        if (!this.getStatus().equals((Object)prevStatus)) {
            logger.info("Transport " + this.getPathName() + " status updated: " + (Object)((Object)this.getStatus()));
            for (TransportListener listener : listeners) {
                listener.statusUpdated(this.getStatus());
            }
            updated = true;
        }
        if (!this.getMetadata().equals((Object)prevMetadata)) {
            logger.info("Transport " + this.getPathName() + " metadata updated: " + this.getMetadata());
            for (TransportListener listener : listeners) {
                listener.metadataUpdated(this.getMetadata());
            }
            updated = true;
        }
        boolean updatedCommodities = false;
        List<Commodity> commodities = this.getCommodities();
        for (int k = 0; k < commodities.size(); ++k) {
            if (k != prevCommodities.size() && commodities.get(k).equals(prevCommodities.get(k))) continue;
            updatedCommodities = true;
            break;
        }
        if (updatedCommodities) {
            logger.info("Transport " + this.getPathName() + " commodities updated: " + this.getCommodities());
            List<Commodity> commodities2 = this.getCommodities();
            for (TransportListener listener : listeners) {
                listener.commoditiesUpdated(commodities2);
            }
            updated = true;
        }
        Path parentPath = this.getParentPath();
        if (updated && this.getServices().getRegistry().isModelRegistered(parentPath)) {
            boolean added;
            Cluster parentCluster = Cluster.getInstance(parentPath.getPathName(), this.getServices());
            boolean bl = added = !parentCluster.getTransportsMap().containsKey(this.getPathName());
            if (added) {
                parentCluster.addTransport(this);
            }
            Collection<Transport> transports = parentCluster.getTransports();
            logger.info("Transport " + this.getPathName() + " calling parent cluster's update");
            List clusterListeners = parentCluster.getListeners();
            for (ClusterListener listener : clusterListeners) {
                if (added) {
                    listener.transportAdded(this);
                }
                listener.transportUpdated(this);
                listener.transportsUpdated(transports);
            }
        }
        return updated;
    }

    @Override
    protected void route(JsonObject json, PathfinderServices services) {
        JsonObject route = json.getAsJsonObject("route");
        logger.info("Transport setting route: " + this.getPathName());
        this.route = new Route(route, services);
        logger.info("Transport updating route: " + this.getPathName());
        for (TransportListener listener : this.getListeners()) {
            listener.routed(this.getRoute());
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("path", this.getPathName());
        json.addProperty("model", this.getModelType().toString());
        json.addProperty("latitude", (Number)this.getLatitude());
        json.addProperty("longitude", (Number)this.getLongitude());
        json.addProperty("status", this.getStatus().toString());
        json.add("metadata", (JsonElement)this.getMetadata());
        JsonArray commodities = new JsonArray();
        json.add("commodities", (JsonElement)commodities);
        if (this.route != null) {
            json.addProperty("route", this.route.toString());
        }
        return json;
    }

    public String toString() {
        return this.toJson().toString();
    }

    @Override
    protected Transport getThis() {
        return this;
    }
}

