/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import xyz.thepathfinder.android.ClusterListener;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.CommodityStatus;
import xyz.thepathfinder.android.Pathfinder;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Route;
import xyz.thepathfinder.android.SubscribableCrudModel;
import xyz.thepathfinder.android.Transport;
import xyz.thepathfinder.android.TransportStatus;

public class Cluster
extends SubscribableCrudModel<ClusterListener> {
    private static final Logger logger = Logger.getLogger(Cluster.class.getName());
    private static final String MODEL = Pathfinder.CLUSTER;
    private Map<String, Commodity> commodities;
    private Map<String, Cluster> subclusters;
    private Map<String, Transport> transports;
    private List<Route> routes;

    private Cluster(String path, PathfinderServices services) {
        super(path, services);
        logger.finest("Constructing cluster by path: " + path);
        boolean isRegistered = this.getServices().getRegistry().isModelRegistered(path);
        if (isRegistered) {
            logger.warning("Illegal Argument Exception: Constructing cluster with path that already exists: " + path);
            throw new IllegalArgumentException("Cluster path already exists: " + path);
        }
        this.getServices().getRegistry().registerModel(this);
        this.transports = new HashMap<String, Transport>();
        this.commodities = new HashMap<String, Commodity>();
        this.subclusters = new HashMap<String, Cluster>();
        this.routes = new ArrayList<Route>();
        logger.finest("Done constructing cluster by path: " + this);
    }

    protected static Cluster getInstance(String path, PathfinderServices services) {
        Cluster cluster = (Cluster)services.getRegistry().getModel(path);
        if (cluster == null && !path.equals("")) {
            cluster = new Cluster(path, services);
        }
        logger.finest("Getting cluster instance: " + cluster);
        return cluster;
    }

    protected static Cluster getInstance(JsonObject clusterJson, PathfinderServices services) {
        boolean canParseToCluster = Cluster.checkClusterFields(clusterJson);
        if (!canParseToCluster) {
            logger.warning("Illegal Argument Exception: JSON could not be parsed to a cluster: " + clusterJson);
            throw new IllegalArgumentException("JSON could not be parsed to a cluster");
        }
        String path = Cluster.getPath(clusterJson);
        Cluster cluster = Cluster.getInstance(path, services);
        logger.finest("Notifying cluster of update: \nCurrent cluster: " + cluster + "\nNew JSON: " + clusterJson);
        cluster.notifyUpdate(null, clusterJson);
        return cluster;
    }

    private static boolean checkClusterFields(JsonObject clusterJson) {
        return clusterJson.has("path") && clusterJson.has("transports") && clusterJson.get("transports").isJsonArray() && clusterJson.has("commodities") && clusterJson.get("commodities").isJsonArray() && clusterJson.has("subClusters") && clusterJson.get("subClusters").isJsonArray();
    }

    private static String getPath(JsonObject clusterJson) {
        return clusterJson.get("path").getAsString();
    }

    public Commodity createCommodity(String name, double startLatitude, double startLongitude, double endLatitude, double endLongitude, CommodityStatus status, JsonObject metadata) {
        if (!this.isConnected()) {
            logger.warning("Illegal State Exception: Not connected to cluster, cannot create commodity");
            throw new IllegalStateException("Not connected to cluster, cannot create commodity");
        }
        String path = this.getChildPath(name);
        return new Commodity(path, startLatitude, startLongitude, endLatitude, endLongitude, status, metadata, this.getServices());
    }

    private Commodity createCommodity(JsonObject commodityJson) {
        return Commodity.getInstance(commodityJson, this.getServices());
    }

    public Commodity getCommodity(String name) {
        return this.commodities.get(this.getChildPath(name));
    }

    public Collection<Commodity> getCommodities() {
        return Collections.unmodifiableCollection(this.commodities.values());
    }

    public Map<String, Commodity> getCommoditiesMap() {
        return Collections.unmodifiableMap(this.commodities);
    }

    private void setCommodities(Iterable<Commodity> commodities) {
        for (Commodity commodity : commodities) {
            this.commodities.put(commodity.getPath(), commodity);
        }
    }

    private void setCommodities(Map<String, Commodity> commodities) {
        this.commodities = commodities;
    }

    public Cluster createSubcluster(String name) {
        if (!this.isConnected()) {
            logger.warning("Illegal State Exception: Not connected to cluster cannot create subcluster");
            throw new IllegalStateException("The cluster is not connected on the Pathfinder server");
        }
        return Cluster.getInstance(this.getChildPath(name), this.getServices());
    }

    public Cluster getSubcluster(String name) {
        return this.subclusters.get(this.getChildPath(name));
    }

    public Collection<Cluster> getSubclusters() {
        return Collections.unmodifiableCollection(this.subclusters.values());
    }

    public Map<String, Cluster> getSubclustersMap() {
        return Collections.unmodifiableMap(this.subclusters);
    }

    private void setSubclusters(Iterable<Cluster> subclusters) {
        for (Cluster cluster : subclusters) {
            this.subclusters.put(cluster.getPath(), cluster);
        }
    }

    private void setSubclusters(Map<String, Cluster> subclusters) {
        this.subclusters = subclusters;
    }

    public Transport createTransport(String name, double latitude, double longitude, TransportStatus status, JsonObject metadata) {
        if (!this.isConnected()) {
            logger.warning("Illegal State Exception: Not connected to cluster cannot create transport");
            throw new IllegalStateException("Not connected to cluster, cannot create transport");
        }
        String path = this.getChildPath(name);
        return new Transport(path, latitude, longitude, status, metadata, this.getServices());
    }

    private Transport createTransport(JsonObject transportJson) {
        return Transport.getInstance(transportJson, this.getServices());
    }

    public Transport getTransport(String name) {
        return this.transports.get(this.getChildPath(name));
    }

    public Collection<Transport> getTransports() {
        return Collections.unmodifiableCollection(this.transports.values());
    }

    public Map<String, Transport> getTransportsMap() {
        return Collections.unmodifiableMap(this.transports);
    }

    private void setTransports(Iterable<Transport> transports) {
        for (Transport transport : transports) {
            this.transports.put(transport.getPath(), transport);
        }
    }

    private void setTransports(Map<String, Transport> transports) {
        this.transports = transports;
    }

    private void setRoutes(List<Route> routes) {
        this.routes = routes;
    }

    public Collection<Route> getRoutes() {
        return Collections.unmodifiableCollection(this.routes);
    }

    @Override
    protected String getModel() {
        return MODEL;
    }

    @Override
    protected JsonObject createValueJson() {
        JsonObject json = new JsonObject();
        json.addProperty("path", this.getPath());
        json.addProperty("model", this.getModel());
        return json;
    }

    @Override
    protected boolean updateFields(JsonObject json) {
        Commodity commodity;
        Cluster cluster;
        Transport transport;
        ArrayList<Commodity> updatedCommodities = new ArrayList<Commodity>();
        ArrayList<Cluster> updatedClusters = new ArrayList<Cluster>();
        ArrayList<Transport> updatedTransports = new ArrayList<Transport>();
        logger.finest("Updating Cluster " + this.getPath() + " with: " + json.toString());
        boolean updated = false;
        Map<String, Commodity> prevCommodities = this.getCommoditiesMap();
        HashMap<String, Commodity> commodityMap = new HashMap<String, Commodity>();
        if (json.has("commodities")) {
            JsonArray commodities = json.getAsJsonArray("commodities");
            for (JsonElement commodityJson : commodities) {
                String path = ((JsonObject)commodityJson).get("path").getAsString();
                Commodity commodity2 = Commodity.getInstance(path, this.getServices());
                if (commodity2.notifyUpdate(null, (JsonObject)commodityJson)) {
                    updatedCommodities.add(commodity2);
                }
                commodityMap.put(commodity2.getPath(), commodity2);
            }
        }
        Map<String, Transport> prevTransports = this.getTransportsMap();
        HashMap<String, Transport> transportMap = new HashMap<String, Transport>();
        if (json.has("transports")) {
            JsonArray transports = json.getAsJsonArray("transports");
            for (JsonElement transportJson : transports) {
                String path = ((JsonObject)transportJson).get("path").getAsString();
                transport = Transport.getInstance(path, this.getServices());
                if (transport.notifyUpdate(null, (JsonObject)transportJson)) {
                    updatedTransports.add(transport);
                }
                transportMap.put(transport.getPath(), transport);
            }
        }
        Map<String, Cluster> prevSubclusters = this.getSubclustersMap();
        HashMap<String, Cluster> clusterMap = new HashMap<String, Cluster>();
        if (json.has("subClusters")) {
            JsonArray clusters = json.getAsJsonArray("subClusters");
            for (JsonElement clusterJson : clusters) {
                String path = ((JsonObject)clusterJson).get("path").getAsString();
                Cluster cluster2 = Cluster.getInstance(path, this.getServices());
                if (cluster2.notifyUpdate(null, (JsonObject)clusterJson)) {
                    updatedClusters.add(cluster2);
                }
                clusterMap.put(cluster2.getPath(), cluster2);
            }
        }
        this.setCommodities(commodityMap);
        this.setSubclusters(clusterMap);
        this.setTransports(transportMap);
        List listeners = this.getListeners();
        for (String path : clusterMap.keySet()) {
            if (!prevSubclusters.containsKey(path)) {
                cluster = (Cluster)clusterMap.get(path);
                logger.finest("Cluster " + this.getPath() + " subcluster added: " + cluster.getPath());
                for (ClusterListener listener : listeners) {
                    listener.subclusterAdded(cluster);
                }
            }
            updated = true;
        }
        for (String path : commodityMap.keySet()) {
            if (!prevCommodities.containsKey(path)) {
                commodity = (Commodity)commodityMap.get(path);
                logger.finest("Cluster " + this.getPath() + " commodity added: " + commodity.getPath());
                for (ClusterListener listener : listeners) {
                    listener.commodityAdded(commodity);
                }
            }
            updated = true;
        }
        for (String path : transportMap.keySet()) {
            if (!prevTransports.containsKey(path)) {
                transport = (Transport)transportMap.get(path);
                logger.finest("Cluster " + this.getPath() + " transport added: " + transport.getPath());
                for (ClusterListener listener : listeners) {
                    listener.transportAdded(transport);
                }
            }
            updated = true;
        }
        for (String path : prevCommodities.keySet()) {
            if (!commodityMap.containsKey(path)) {
                commodity = prevCommodities.get(path);
                logger.finest("Cluster " + this.getPath() + " commodity removed: " + commodity.getPath());
                for (ClusterListener listener : listeners) {
                    listener.commodityRemoved(commodity);
                }
            }
            updated = true;
        }
        for (String path : prevSubclusters.keySet()) {
            if (!clusterMap.containsKey(path)) {
                cluster = prevSubclusters.get(path);
                logger.finest("Cluster " + this.getPath() + " subcluster removed: " + cluster.getPath());
                for (ClusterListener listener : listeners) {
                    listener.subclusterRemoved(cluster);
                }
            }
            updated = true;
        }
        for (String path : prevTransports.keySet()) {
            if (!transportMap.containsKey(path)) {
                transport = prevTransports.get(path);
                logger.finest("Cluster " + this.getPath() + " transport removed: " + transport.getPath());
                for (ClusterListener listener : listeners) {
                    listener.transportRemoved(transport);
                }
            }
            updated = true;
        }
        for (Cluster cluster3 : updatedClusters) {
            logger.finest("Cluster " + this.getPath() + " subcluster updated: " + cluster3.getPath());
            for (ClusterListener listener : listeners) {
                listener.subclusterUpdated(cluster3);
            }
            updated = true;
        }
        for (Commodity commodity2 : updatedCommodities) {
            logger.finest("Cluster " + this.getPath() + " commodity updated: " + commodity2.getPath());
            for (ClusterListener listener : listeners) {
                listener.commodityUpdated(commodity2);
            }
            updated = true;
        }
        for (Transport transport2 : updatedTransports) {
            logger.finest("Cluster " + this.getPath() + " transport updated: " + transport2.getPath());
            for (ClusterListener listener : listeners) {
                listener.transportUpdated(transport2);
            }
            updated = true;
        }
        if (!updatedCommodities.isEmpty()) {
            logger.finest("Cluster " + this.getPath() + " commodities updated " + this.getCommodities());
            for (ClusterListener listener : listeners) {
                listener.commoditiesUpdated(this.getCommodities());
            }
        }
        if (!updatedClusters.isEmpty()) {
            logger.finest("Cluster " + this.getPath() + " subclusters updated " + this.getSubclusters());
            for (ClusterListener listener : listeners) {
                listener.subclustersUpdated(this.getSubclusters());
            }
        }
        if (!updatedTransports.isEmpty()) {
            logger.finest("Cluster " + this.getPath() + " transports updated " + this.getTransports());
            for (ClusterListener listener : listeners) {
                listener.transportsUpdated(this.getTransports());
            }
        }
        String parentPath = this.getParentPath();
        if (updated && this.getServices().getRegistry().isModelRegistered(parentPath)) {
            Cluster parentCluster = Cluster.getInstance(parentPath, this.getServices());
            Collection<Cluster> clusters = parentCluster.getSubclusters();
            List clusterListeners = parentCluster.getListeners();
            logger.finest("Cluster " + this.getPath() + " calling parent cluster's update");
            for (ClusterListener listener : clusterListeners) {
                listener.subclusterUpdated(this);
                listener.subclustersUpdated(clusters);
            }
        }
        return updated;
    }

    @Override
    protected void route(JsonObject json, PathfinderServices services) {
        JsonArray routesJson = json.getAsJsonArray("route");
        ArrayList<Route> routes = new ArrayList<Route>();
        logger.info("Cluster adding routes: " + this.getPath());
        for (JsonElement route : routesJson) {
            routes.add(new Route((JsonObject)route, services));
        }
        this.setRoutes(routes);
        logger.info("Cluster updating routes: " + this.getPath());
        for (ClusterListener listener : this.getListeners()) {
            listener.routed(new ArrayList<Route>(this.getRoutes()));
        }
    }

    public String toString() {
        JsonObject json = new JsonObject();
        json.addProperty("path", this.getPath());
        json.addProperty("commodities", this.getCommodities().toString());
        json.addProperty("subclusters", this.getSubclusters().toString());
        json.addProperty("transports", this.getTransports().toString());
        json.addProperty("routes", this.getRoutes().toString());
        return json.toString();
    }
}

