/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.MessageHandler;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.ModelRegistry;

class MessageHandler
implements MessageHandler.Whole<String> {
    private final ModelRegistry registry;
    private static final Logger logger = Logger.getLogger(MessageHandler.class.getName());
    private int receivedMessageCount;

    protected MessageHandler(ModelRegistry registry) {
        this.registry = registry;
        this.receivedMessageCount = 0;
    }

    public void onMessage(String message) {
        logger.log(Level.INFO, "Received json: " + message);
        ++this.receivedMessageCount;
        JsonObject json = new JsonParser().parse(message).getAsJsonObject();
        if (!(json.has("message") && json.has("model") && json.has("path"))) {
            logger.warning("Ignoring invalid message: " + json.toString());
        } else {
            String type = json.get("message").getAsString();
            String path = json.get("path").getAsString();
            Model model = this.registry.getModel(path);
            logger.finest("Notifying " + model.getPath() + " of message");
            model.notifyUpdate(type, json);
        }
    }

    public int getReceivedMessageCount() {
        return this.receivedMessageCount;
    }
}

