/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.Listenable;
import xyz.thepathfinder.android.Listener;
import xyz.thepathfinder.android.Path;
import xyz.thepathfinder.android.PathfinderServices;

public abstract class Model<E extends Listener<? extends Model>>
extends Listenable<E> {
    private static final Logger logger = Logger.getLogger(Model.class.getName());
    private final Path path;
    private final PathfinderServices services;
    private boolean isConnected;

    public Model(String path, PathfinderServices services) {
        this.path = new Path(path);
        this.services = services;
        this.isConnected = false;
    }

    public String getPath() {
        return this.path.getPath();
    }

    protected String getChildPath(String name) {
        return this.path.getChildPath(name);
    }

    public String getParentPath() {
        return this.path.getParentPath();
    }

    public Cluster getParentCluster() {
        String parentPath = this.getParentPath();
        return Cluster.getInstance(parentPath, this.services);
    }

    protected PathfinderServices getServices() {
        return this.services;
    }

    protected void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private boolean updateType(String reason, JsonObject json) {
        boolean updated = false;
        JsonObject value = null;
        if (json.has("value")) {
            value = json.getAsJsonObject("value");
            updated = this.updateFields(value);
        }
        List listeners = this.getListeners();
        if (updated && !reason.equals("Updated")) {
            logger.finest("Model " + this.getPath() + " updated");
            for (Listener listener : listeners) {
                listener.updated(this);
            }
        }
        if (reason.equals("Updated")) {
            logger.finest("Model " + this.getPath() + " updated");
            for (Listener listener : listeners) {
                listener.updated(this);
            }
            return updated;
        }
        if (reason.equals("Routed")) {
            logger.finest("Model " + this.getPath() + " routed");
            this.route(json, this.getServices());
            return true;
        }
        if (reason.equals("Model")) {
            logger.finest("Model " + this.getPath() + " connected");
            for (Listener listener : listeners) {
                listener.connected(this);
            }
            return updated;
        }
        if (reason.equals("Subscribed")) {
            logger.finest("Model " + this.getPath() + " subscribed");
            for (Listener listener : listeners) {
                listener.subscribed(this);
            }
            return updated;
        }
        if (reason.equals("RouteSubscribed")) {
            logger.finest("Model " + this.getPath() + " route subscribed");
            for (Listener listener : listeners) {
                listener.routeSubscribed(this);
            }
            return updated;
        }
        if (reason.equals("Unsubscribed")) {
            logger.finest("Model " + this.getPath() + " unsubscribed");
            for (Listener listener : listeners) {
                listener.unsubscribed(this);
            }
            return updated;
        }
        if (reason.equals("RouteUnsubscribed")) {
            logger.finest("Model " + this.getPath() + " route unsubscribed");
            for (Listener listener : listeners) {
                listener.routeUnsubscribed(this);
            }
            return updated;
        }
        if (reason.equals("Created")) {
            logger.finest("Model " + this.getPath() + " created");
            for (Listener listener : listeners) {
                listener.created(this);
            }
            return updated;
        }
        if (reason.equals("Deleted")) {
            logger.finest("Model " + this.getPath() + " deleted");
            for (Listener listener : listeners) {
                this.setConnected(false);
                listener.deleted(this);
            }
            return updated;
        }
        if (reason.equals("Error") && value != null) {
            logger.warning("Model " + this.getPath() + " received error: " + value.get("reason").getAsString());
            for (Listener listener : listeners) {
                listener.error(value.get("reason").getAsString());
            }
            return updated;
        }
        logger.warning("Invalid message sent to " + this.getPath() + " with type: " + reason + "\nJson: " + json);
        return updated;
    }

    @Override
    protected boolean notifyUpdate(String reason, JsonObject json) {
        if (!json.has("model") || !json.get("model").getAsString().equals(this.getModel())) {
            logger.warning("Invalid model type: " + json + " given to a " + this.getModel());
            return false;
        }
        this.setConnected(true);
        if (reason != null) {
            return this.updateType(reason, json);
        }
        if (this.updateFields(json)) {
            List listeners = this.getListeners();
            for (Listener listener : listeners) {
                listener.updated(this);
            }
            return true;
        }
        return false;
    }

    protected abstract String getModel();

    protected abstract JsonObject createValueJson();

    protected abstract boolean updateFields(JsonObject var1);

    protected abstract void route(JsonObject var1, PathfinderServices var2);
}

