/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;
import xyz.thepathfinder.android.Cluster;
import xyz.thepathfinder.android.Commodity;
import xyz.thepathfinder.android.Connection;
import xyz.thepathfinder.android.ModelRegistry;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.Transport;

public class Pathfinder {
    protected static String CLUSTER = "Cluster";
    protected static String COMMODITY = "Commodity";
    protected static String TRANSPORT = "Vehicle";
    private PathfinderServices services;
    private URI webSocketUrl;
    private static Logger logger = Logger.getLogger(Pathfinder.class.getName());

    public Pathfinder(String applicationIdentifier, String userCredentials) {
        try {
            this.webSocketUrl = new URI("ws://api.thepathfinder.xyz/socket");
        }
        catch (URISyntaxException e) {
            logger.severe(e.getMessage());
        }
        ModelRegistry registry = new ModelRegistry();
        Connection connection = new Connection(applicationIdentifier, userCredentials, registry);
        this.services = new PathfinderServices(registry, connection);
    }

    protected Pathfinder(String applicationIdentifier, String userCredentials, URI webSocketUrl) {
        this.webSocketUrl = webSocketUrl;
        ModelRegistry registry = new ModelRegistry();
        Connection connection = new Connection(applicationIdentifier, userCredentials, registry);
        this.services = new PathfinderServices(registry, connection);
    }

    public void connect() throws IOException {
        if (!this.isConnected()) {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            try {
                container.connectToServer((Object)this.services.getConnection(), this.webSocketUrl);
            }
            catch (DeploymentException e) {
                logger.severe(e.getMessage());
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
                throw e;
            }
        }
    }

    public Cluster getDefaultCluster() {
        return Cluster.getInstance("/default", this.services);
    }

    public Cluster getCluster(String path) {
        return Cluster.getInstance(path, this.services);
    }

    public Commodity getCommodity(String path) {
        return Commodity.getInstance(path, this.services);
    }

    public Transport getTransport(String path) {
        return Transport.getInstance(path, this.services);
    }

    public boolean isConnected() {
        return this.services.getConnection().isConnected();
    }

    protected long getSentMessageCount() {
        return this.services.getConnection().getSentMessageCount();
    }

    protected long getReceivedMessageCount() {
        return this.services.getConnection().getReceivedMessageCount();
    }

    public void close() throws IOException {
        CloseReason reason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Connection ended by user");
        this.close(reason);
    }

    public void close(CloseReason reason) throws IOException {
        if (this.isConnected()) {
            logger.finest("Connection closed");
            this.services.getConnection().close(reason);
        }
    }
}

