/*
 * Decompiled with CFR 0.152.
 */
package xyz.thepathfinder.android;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.logging.Logger;
import xyz.thepathfinder.android.Listener;
import xyz.thepathfinder.android.Model;
import xyz.thepathfinder.android.PathfinderServices;
import xyz.thepathfinder.android.SubscribableModel;

public abstract class SubscribableCrudModel<E extends Listener<? extends Model>>
extends SubscribableModel<E> {
    private static final Logger logger = Logger.getLogger(SubscribableCrudModel.class.getName());

    public SubscribableCrudModel(String path, PathfinderServices services) {
        super(path, services);
    }

    public void connect() {
        JsonObject json = this.getMessageHeader("Read");
        this.getServices().getConnection().sendMessage(json.toString());
    }

    public void create() {
        if (this.isConnected()) {
            logger.warning("Cannot create a connected model: " + this.getPath());
            throw new IllegalStateException("Already created");
        }
        JsonObject json = this.getMessageHeader("Create");
        json.add("value", (JsonElement)this.createValueJson());
        this.getServices().getConnection().sendMessage(json.toString());
    }

    public void delete() {
        if (!this.isConnected()) {
            logger.warning("Cannot delete a model not connected: " + this.getPath());
            throw new IllegalStateException("Not connected to object on Pathfinder server");
        }
        JsonObject json = this.getMessageHeader("Delete");
        this.getServices().getConnection().sendMessage(json.toString());
    }

    protected void update(JsonObject value) {
        if (!this.isConnected()) {
            logger.warning("Cannot update a model not connected: " + this.getPath());
            throw new IllegalStateException("Not connected to object on Pathfinder server");
        }
        JsonObject json = this.getMessageHeader("Update");
        json.add("value", (JsonElement)value);
        this.getServices().getConnection().sendMessage(json.toString());
    }
}

