/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.api;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.http.HttpMethod;

public enum FileEnum {
    GET(FileEnum.getUri("https://api.aliyundrive.com/v2/file/get"), HttpMethod.POST),
    GET_DOWNLOAD_URL(FileEnum.getUri("https://api.aliyundrive.com/v2/file/get_download_url"), HttpMethod.POST),
    LIST(FileEnum.getUri("https://api.aliyundrive.com/adrive/v3/file/list"), HttpMethod.POST),
    SEARCH(FileEnum.getUri("https://api.aliyundrive.com/adrive/v3/file/search"), HttpMethod.POST),
    MULTI_DOWNLOAD_URL(FileEnum.getUri("https://api.aliyundrive.com/adrive/v1/file/multiDownloadUrl"), HttpMethod.POST),
    CREATE_WITH_FOLDERS(FileEnum.getUri("https://api.aliyundrive.com/adrive/v2/file/createWithFolders"), HttpMethod.POST),
    UPDATE(FileEnum.getUri("https://api.aliyundrive.com/v3/file/update"), HttpMethod.POST),
    COMPLETE(FileEnum.getUri("https://api.aliyundrive.com/v2/file/complete"), HttpMethod.POST);

    private final URI api;
    private final HttpMethod httpMethod;

    private FileEnum(URI api, HttpMethod httpMethod) {
        this.api = api;
        this.httpMethod = httpMethod;
    }

    static URI getUri(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URI getApi() {
        return this.api;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }
}

