/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.autoconfigure;

import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;
import xyz.xuminghai.autoconfigure.CacheEnum;
import xyz.xuminghai.autoconfigure.CacheProperties;
import xyz.xuminghai.cache.BaseCache;
import xyz.xuminghai.cache.Cache;
import xyz.xuminghai.cache.NullCache;
import xyz.xuminghai.cache.decorator.LoggingDecorator;
import xyz.xuminghai.cache.decorator.LruDecorator;
import xyz.xuminghai.cache.decorator.ScheduledDecorator;
import xyz.xuminghai.serializer.KryoSerializer;
import xyz.xuminghai.serializer.Serializer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
@EnableConfigurationProperties(value={CacheProperties.class})
public class CacheAutoConfiguration {
    private final CacheProperties cacheProperties;

    public CacheAutoConfiguration(CacheProperties cacheProperties) {
        this.cacheProperties = cacheProperties;
    }

    @Bean
    public BaseCache baseCache() {
        return new BaseCache();
    }

    @Bean
    public Serializer serializer() {
        return new KryoSerializer();
    }

    @Bean
    public Cache cache(BeanFactory beanFactory) {
        if (!this.cacheProperties.isEnableCache()) {
            return new NullCache();
        }
        Cache cache = (Cache)beanFactory.getBean(this.cacheProperties.getCacheInstance());
        List<CacheEnum> decoratorList = this.cacheProperties.getDecorator();
        if (decoratorList.contains((Object)CacheEnum.NONE)) {
            return cache;
        }
        for (CacheEnum cacheEnum : decoratorList) {
            if (cacheEnum == CacheEnum.LOGGING) {
                cache = new LoggingDecorator(cache);
            }
            if (cacheEnum == CacheEnum.LRU) {
                cache = new LruDecorator(cache, this.cacheProperties.getLruMaxCapacity());
            }
            if (cacheEnum != CacheEnum.SCHEDULED) continue;
            cache = new ScheduledDecorator(cache, this.cacheProperties.getScheduledFixedDelay());
        }
        return cache;
    }
}

