/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import xyz.xuminghai.autoconfigure.CacheEnum;
import xyz.xuminghai.cache.AbstractCacheInstance;
import xyz.xuminghai.cache.BaseCache;

@ConfigurationProperties(value="xyz.xuminghai.cache")
public class CacheProperties {
    private boolean enableCache = true;
    private List<CacheEnum> decorator = new ArrayList<CacheEnum>(3){
        {
            this.add(CacheEnum.LOGGING);
            this.add(CacheEnum.LRU);
            this.add(CacheEnum.SCHEDULED);
        }
    };
    private int lruMaxCapacity = 1024;
    private int scheduledFixedDelay = 3600;
    private Class<? extends AbstractCacheInstance> cacheInstance = BaseCache.class;

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public List<CacheEnum> getDecorator() {
        return this.decorator;
    }

    public int getLruMaxCapacity() {
        return this.lruMaxCapacity;
    }

    public int getScheduledFixedDelay() {
        return this.scheduledFixedDelay;
    }

    public Class<? extends AbstractCacheInstance> getCacheInstance() {
        return this.cacheInstance;
    }

    public void setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
    }

    public void setDecorator(List<CacheEnum> decorator) {
        this.decorator = decorator;
    }

    public void setLruMaxCapacity(int lruMaxCapacity) {
        this.lruMaxCapacity = lruMaxCapacity;
    }

    public void setScheduledFixedDelay(int scheduledFixedDelay) {
        this.scheduledFixedDelay = scheduledFixedDelay;
    }

    public void setCacheInstance(Class<? extends AbstractCacheInstance> cacheInstance) {
        this.cacheInstance = cacheInstance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheProperties)) {
            return false;
        }
        CacheProperties other = (CacheProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableCache() != other.isEnableCache()) {
            return false;
        }
        if (this.getLruMaxCapacity() != other.getLruMaxCapacity()) {
            return false;
        }
        if (this.getScheduledFixedDelay() != other.getScheduledFixedDelay()) {
            return false;
        }
        List<CacheEnum> this$decorator = this.getDecorator();
        List<CacheEnum> other$decorator = other.getDecorator();
        if (this$decorator == null ? other$decorator != null : !((Object)this$decorator).equals(other$decorator)) {
            return false;
        }
        Class<? extends AbstractCacheInstance> this$cacheInstance = this.getCacheInstance();
        Class<? extends AbstractCacheInstance> other$cacheInstance = other.getCacheInstance();
        return !(this$cacheInstance == null ? other$cacheInstance != null : !this$cacheInstance.equals(other$cacheInstance));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableCache() ? 79 : 97);
        result = result * 59 + this.getLruMaxCapacity();
        result = result * 59 + this.getScheduledFixedDelay();
        List<CacheEnum> $decorator = this.getDecorator();
        result = result * 59 + ($decorator == null ? 43 : ((Object)$decorator).hashCode());
        Class<? extends AbstractCacheInstance> $cacheInstance = this.getCacheInstance();
        result = result * 59 + ($cacheInstance == null ? 43 : $cacheInstance.hashCode());
        return result;
    }

    public String toString() {
        return "CacheProperties(enableCache=" + this.isEnableCache() + ", decorator=" + this.getDecorator() + ", lruMaxCapacity=" + this.getLruMaxCapacity() + ", scheduledFixedDelay=" + this.getScheduledFixedDelay() + ", cacheInstance=" + this.getCacheInstance() + ")";
    }
}

