/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.autoconfigure;

import java.time.Instant;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import xyz.xuminghai.util.DurationUtils;

@Aspect
class ClientAspect {
    private static final Logger log = LoggerFactory.getLogger(ClientAspect.class);

    ClientAspect() {
    }

    @Pointcut(value="execution(public * getCache())")
    private void excludePointcut() {
    }

    @Around(value="target(xyz.xuminghai.template.ReactiveClientTemplate) && !excludePointcut()")
    private Object reactiveClientTemplateArdound(ProceedingJoinPoint pjp) throws Throwable {
        Instant startTime = Instant.now();
        Mono mono = (Mono)pjp.proceed();
        Signature signature = pjp.getSignature();
        return mono.doOnError(throwable -> {
            WebClientResponseException e = (WebClientResponseException)throwable;
            log.error("\u53d1\u751f\u7684\u9519\u8bef\u8bf7\u6c42\uff1a{}", (Object)e.getMessage());
            log.error("\u963f\u91cc\u4e91\u76d8\u54cd\u5e94\u7684\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getResponseBodyAsString());
        }).doOnNext(o -> log.info("\u3010{}#{}\u3011\u6267\u884c\u6210\u529f\u8017\u65f6\uff1a{}", new Object[]{signature.getDeclaringTypeName(), signature.getName(), DurationUtils.between(startTime, Instant.now())}));
    }

    @Pointcut(value="target(xyz.xuminghai.template.BlockClientTemplate) && !excludePointcut()")
    private void blockClientTemplatePointcut() {
    }

    @AfterThrowing(pointcut="blockClientTemplatePointcut()", throwing="e")
    private void blockClientTemplateThrowing(WebClientResponseException e) {
        log.error("\u53d1\u751f\u7684\u9519\u8bef\u8bf7\u6c42\uff1a{}", (Object)e.getMessage());
        log.error("\u963f\u91cc\u4e91\u76d8\u54cd\u5e94\u7684\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getResponseBodyAsString());
    }

    @Around(value="blockClientTemplatePointcut()")
    private Object blockClientTemplateAround(ProceedingJoinPoint pjp) throws Throwable {
        Instant startTime = Instant.now();
        Object o = pjp.proceed();
        Signature signature = pjp.getSignature();
        log.info("\u3010{}#{}\u3011\u6267\u884c\u6210\u529f\u8017\u65f6\uff1a{}", new Object[]{signature.getDeclaringTypeName(), signature.getName(), DurationUtils.between(startTime, Instant.now())});
        return o;
    }
}

