/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.autoconfigure;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import xyz.xuminghai.autoconfigure.CacheAutoConfiguration;
import xyz.xuminghai.autoconfigure.ClientAspect;
import xyz.xuminghai.autoconfigure.ClientProperties;
import xyz.xuminghai.autoconfigure.TokenResponse;
import xyz.xuminghai.autoconfigure.TokenStatic;
import xyz.xuminghai.cache.Cache;
import xyz.xuminghai.core.ReactiveFileDao;
import xyz.xuminghai.core.ReactiveRecycleDao;
import xyz.xuminghai.core.impl.ReactiveFileDaoImpl;
import xyz.xuminghai.core.impl.ReactiveRecycleDaoImpl;
import xyz.xuminghai.exception.InvalidRefreshTokenException;
import xyz.xuminghai.template.BlockClientTemplate;
import xyz.xuminghai.template.ReactiveClientTemplate;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ClientProperties.class})
@ConditionalOnClass(value={WebClient.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class ClientAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ClientAutoConfiguration.class);
    private final WebClient webClient;
    private final ClientProperties clientProperties;
    private String refreshToken;

    public ClientAutoConfiguration(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        this.refreshToken = Objects.requireNonNull(clientProperties.getRefreshToken(), "\u963f\u91cc\u4e91\u76d8\u7684refreshToken\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5fc5\u987b\u914d\u7f6e\uff01\uff01\uff01");
        this.webClient = WebClient.builder().codecs(clientCodecConfigurer -> {
            ClientCodecConfigurer.ClientDefaultCodecs clientDefaultCodecs = clientCodecConfigurer.defaultCodecs();
            clientDefaultCodecs.maxInMemorySize(clientProperties.getMaxInMemorySize());
            clientDefaultCodecs.enableLoggingRequestDetails(clientProperties.isEnableLoggingRequestDetails());
        }).build();
        this.scheduled(clientProperties.getFixedDelay());
    }

    @Bean
    @ConditionalOnMissingBean
    public WebClient webClient() {
        return this.webClient;
    }

    @Bean
    public ClientAspect clientAspect() {
        return new ClientAspect();
    }

    @Bean
    @ConditionalOnBean(value={WebClient.class})
    public ReactiveFileDao reactiveFileDao(WebClient webClient) {
        return new ReactiveFileDaoImpl(webClient, this.clientProperties.getUploadRetries(), this.clientProperties.getUploadFragmentation());
    }

    @Bean
    @ConditionalOnBean(value={WebClient.class})
    public ReactiveRecycleDao reactiveRecycleDao(WebClient webClient) {
        return new ReactiveRecycleDaoImpl(webClient);
    }

    @Bean
    @ConditionalOnBean(value={Cache.class, ReactiveFileDao.class, ReactiveRecycleDao.class})
    public BlockClientTemplate blockClientTemplate(Cache cache, ReactiveFileDao reactiveFileDao, ReactiveRecycleDao reactiveRecycleDao) {
        return new BlockClientTemplate(cache, reactiveFileDao, reactiveRecycleDao);
    }

    @Bean
    @ConditionalOnBean(value={Cache.class, ReactiveFileDao.class, ReactiveRecycleDao.class})
    public ReactiveClientTemplate reactiveClientTemplate(Cache cache, ReactiveFileDao reactiveFileDao, ReactiveRecycleDao reactiveRecycleDao) {
        return new ReactiveClientTemplate(cache, reactiveFileDao, reactiveRecycleDao);
    }

    private void scheduled() {
        log.info("\u5237\u65b0\u963f\u91cc\u4e91\u76d8\u8bbf\u95ee\u4ee4\u724c\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
        TokenResponse tokenResponse = this.refresh();
        this.refreshToken = tokenResponse.getRefreshToken();
        try {
            Class<TokenStatic> tokenStaticClass = TokenStatic.class;
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            for (Field field : tokenStaticClass.getDeclaredFields()) {
                modifiers.set(field, field.getModifiers() & 0xFFFFFFEF);
                String[] split = field.getName().toLowerCase(Locale.ROOT).split("_");
                StringBuilder methodName = new StringBuilder("get");
                for (String s : split) {
                    methodName.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1));
                }
                try {
                    Method method = tokenResponse.getClass().getMethod(methodName.toString(), new Class[0]);
                    field.set(tokenStaticClass, method.invoke((Object)tokenResponse, new Object[0]));
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                modifiers.setInt(field, field.getModifiers() | 0x10);
            }
            modifiers.setAccessible(false);
            Field defaultRequest = this.webClient.getClass().getDeclaredField("defaultRequest");
            defaultRequest.setAccessible(true);
            Consumer<WebClient.RequestHeadersSpec> consumer = requestHeadersSpec -> requestHeadersSpec.accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM}).headers(httpHeaders -> httpHeaders.setBearerAuth(TokenStatic.ACCESS_TOKEN));
            defaultRequest.set(this.webClient, consumer);
            defaultRequest.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        log.info("\u5237\u65b0\u963f\u91cc\u4e91\u76d8\u8bbf\u95ee\u4ee4\u724c\u5df2\u5b8c\u6210-----------------------------");
    }

    private void scheduled(int fixedDelay) {
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(this::scheduled, 0L, fixedDelay, TimeUnit.SECONDS);
    }

    private TokenResponse refresh() {
        return (TokenResponse)((WebClient.RequestBodySpec)WebClient.create().post().uri("https://api.aliyundrive.com/token/refresh", new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)this.toString()).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(HttpStatus::isError, clientResponse -> Mono.error((Throwable)new InvalidRefreshTokenException("\u4f7f\u7528\u963f\u91cc\u4e91\u76d8\u7684\u5237\u65b0\u4ee4\u724c\u8ba4\u8bc1\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8fd9\u4e2arefreshToken\uff1a" + this.refreshToken))).bodyToMono(TokenResponse.class).doOnError(Throwable::printStackTrace).block();
    }

    public String toString() {
        return "{\"refresh_token\": \"" + this.refreshToken + "\"}";
    }
}

