/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.cache.decorator;

import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.xuminghai.cache.Cache;

public class LoggingDecorator
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(LoggingDecorator.class);
    private final Cache cache;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.000");
    private int count;
    private int hits;

    public LoggingDecorator(Cache cache) {
        this.cache = cache;
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public Object get(Object key) {
        ++this.count;
        Object value = this.cache.get(key);
        if (value != null) {
            ++this.hits;
        }
        log.info("\u3010{}\u3011\u7f13\u5b58\u547d\u4e2d\u7387\uff1a{}", (Object)this.getName(), (Object)this.getHitRatio());
        return value;
    }

    @Override
    public void remove(Object key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.count = 0;
        this.hits = 0;
        this.cache.clear();
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    private String getHitRatio() {
        return this.decimalFormat.format((double)this.hits / (double)this.count);
    }
}

