/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.cache.decorator;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.xuminghai.cache.Cache;

public class LruDecorator
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(LruDecorator.class);
    private final Cache cache;
    private final Map<Object, Integer> lruMap;

    public LruDecorator(final Cache cache, final int maxCapacity) {
        this.cache = cache;
        this.lruMap = new LinkedHashMap<Object, Integer>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, Integer> eldest) {
                if (this.size() > maxCapacity) {
                    Object key = eldest.getKey();
                    cache.remove(key);
                    Integer count = (Integer)this.remove(key);
                    log.info("\u8bbf\u95ee\u91cf\u4e3a\u3010{}\u3011\u7684\u7f13\u5b58\u88ab\u5220\u9664\uff0c\u5982\u679c\u8bbf\u95ee\u91cf\u8fc7\u5927\uff0c\u8bf7\u8003\u8651\u6269\u5927\u8bbf\u95ee\u96c6\u5408\u7684\u5bb9\u91cf", (Object)count);
                }
                return false;
            }
        };
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public void put(Object key, Object value) {
        this.lruMap.put(key, 0);
        this.cache.put(key, value);
    }

    @Override
    public Object get(Object key) {
        Integer integer = this.lruMap.get(key);
        if (integer == null) {
            integer = 0;
        }
        this.lruMap.put(key, integer + 1);
        return this.cache.get(key);
    }

    @Override
    public void remove(Object key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.lruMap.clear();
        this.cache.clear();
    }

    @Override
    public long size() {
        return this.cache.size();
    }
}

