/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.cache.decorator;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.xuminghai.cache.Cache;

public class ScheduledDecorator
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(ScheduledDecorator.class);
    private final Cache cache;

    public ScheduledDecorator(Cache cache, int fixedDelay) {
        this.cache = cache;
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(() -> {
            log.info("\u3010\u5b9a\u65f6\u6e05\u9664\u7f13\u5b58\u3011_{}\uff1a\u6267\u884c\u4e86\u6e05\u9664\u7f13\u5b58", (Object)this.getName());
            this.clear();
        }, fixedDelay, fixedDelay, TimeUnit.SECONDS);
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public void remove(Object key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public long size() {
        return this.cache.size();
    }
}

