/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.core.impl;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import xyz.xuminghai.api.FileEnum;
import xyz.xuminghai.core.ReactiveFileDao;
import xyz.xuminghai.io.DownloadResource;
import xyz.xuminghai.pojo.entity.upload.UploadStatus;
import xyz.xuminghai.pojo.enums.CheckNameEnum;
import xyz.xuminghai.pojo.request.FileIdRequest;
import xyz.xuminghai.pojo.request.file.CompleteRequest;
import xyz.xuminghai.pojo.request.file.CreateFileRequest;
import xyz.xuminghai.pojo.request.file.CreateFolderRequest;
import xyz.xuminghai.pojo.request.file.ListRequest;
import xyz.xuminghai.pojo.request.file.MultiDownloadUrlRequest;
import xyz.xuminghai.pojo.request.file.SearchRequest;
import xyz.xuminghai.pojo.request.file.UpdateRequest;
import xyz.xuminghai.pojo.response.file.CreateFileResponse;
import xyz.xuminghai.pojo.response.file.DownloadUrlResponse;
import xyz.xuminghai.util.HashUtils;
import xyz.xuminghai.util.IoUtils;
import xyz.xuminghai.util.ProofV1Utils;

public class ReactiveFileDaoImpl
implements ReactiveFileDao {
    private static final Logger log = LoggerFactory.getLogger(ReactiveFileDaoImpl.class);
    private final WebClient webClient;
    private final int uploadRetries;
    private final long uploadFragmentation;

    public ReactiveFileDaoImpl(WebClient webClient, int uploadRetries, int uploadFragmentation) {
        this.webClient = webClient;
        this.uploadRetries = uploadRetries;
        this.uploadFragmentation = (long)uploadFragmentation << 20;
    }

    @Override
    public WebClient.ResponseSpec list(ListRequest listRequest) {
        FileEnum list = FileEnum.LIST;
        return ((WebClient.RequestBodySpec)this.webClient.method(list.getHttpMethod()).uri(list.getApi())).bodyValue((Object)listRequest).retrieve();
    }

    @Override
    public WebClient.ResponseSpec search(SearchRequest searchRequest) {
        FileEnum search = FileEnum.SEARCH;
        return ((WebClient.RequestBodySpec)this.webClient.method(search.getHttpMethod()).uri(search.getApi())).bodyValue((Object)searchRequest).retrieve();
    }

    @Override
    public WebClient.ResponseSpec get(String fileId) {
        FileIdRequest fileIdRequest = new FileIdRequest(fileId);
        FileEnum get = FileEnum.GET;
        return ((WebClient.RequestBodySpec)this.webClient.method(get.getHttpMethod()).uri(get.getApi())).bodyValue((Object)fileIdRequest).retrieve();
    }

    @Override
    public WebClient.ResponseSpec getDownloadUrl(String fileId) {
        FileIdRequest fileIdRequest = new FileIdRequest(fileId);
        FileEnum getDownloadUrl = FileEnum.GET_DOWNLOAD_URL;
        return ((WebClient.RequestBodySpec)this.webClient.method(getDownloadUrl.getHttpMethod()).uri(getDownloadUrl.getApi())).bodyValue((Object)fileIdRequest).retrieve();
    }

    @Override
    public Mono<ResponseEntity<Resource>> downloadFile(String fileId, HttpHeaders requestHttpHeaders) {
        return this.getDownloadUrl(fileId).bodyToMono(DownloadUrlResponse.class).mapNotNull(downloadUrlResponse -> {
            try {
                return DownloadResource.createResource(downloadUrlResponse, requestHttpHeaders);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }).map(downloadResource -> new ResponseEntity((Object)downloadResource, (MultiValueMap)downloadResource.getResponseHttpHeaders(), downloadResource.getHttpStatus()));
    }

    @Override
    public WebClient.ResponseSpec getMultiDownloadUrl(MultiDownloadUrlRequest multiDownloadUrlRequest) {
        FileEnum multiDownloadUrl = FileEnum.MULTI_DOWNLOAD_URL;
        return ((WebClient.RequestBodySpec)this.webClient.method(multiDownloadUrl.getHttpMethod()).uri(multiDownloadUrl.getApi())).bodyValue((Object)multiDownloadUrlRequest).retrieve();
    }

    @Override
    public Mono<ResponseEntity<Resource>> multiDownloadFile(MultiDownloadUrlRequest multiDownloadUrlRequest, HttpHeaders httpHeaders) {
        return null;
    }

    @Override
    public WebClient.ResponseSpec createFolder(CreateFolderRequest createFolderRequest) {
        FileEnum createWithFolders = FileEnum.CREATE_WITH_FOLDERS;
        return ((WebClient.RequestBodySpec)this.webClient.method(createWithFolders.getHttpMethod()).uri(createWithFolders.getApi())).bodyValue((Object)createFolderRequest).retrieve();
    }

    @Override
    public Mono<CreateFileResponse> uploadFile(String parentFileId, Path path, CheckNameEnum checkNameEnum) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("\u8fd9\u4e2a\u8def\u5f84\u4e0d\u662f\u666e\u901a\u6587\u4ef6\uff1a" + path);
        }
        CreateFileRequest createFileRequest = new CreateFileRequest();
        createFileRequest.setParentFileId(parentFileId);
        createFileRequest.setCheckNameMode(checkNameEnum);
        createFileRequest.setName(path.getFileName().toString());
        createFileRequest.setSize(path.toFile().length());
        if (createFileRequest.getSize() > 0L) {
            createFileRequest.setContentHash(HashUtils.sha1(path));
            long size = createFileRequest.getSize();
            ArrayList<CreateFileRequest.PartInfo> list = new ArrayList<CreateFileRequest.PartInfo>();
            int i = 1;
            while (size > this.uploadFragmentation) {
                list.add(new CreateFileRequest.PartInfo(i));
                size -= this.uploadFragmentation;
                ++i;
            }
            if (size != 0L) {
                list.add(new CreateFileRequest.PartInfo(i));
            }
            createFileRequest.setPartInfoList(list);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u3010{}\u3011\u5206\u7247\u6570\u91cf\uff1a{}", (Object)createFileRequest.getName(), (Object)createFileRequest.getPartInfoList().size());
        }
        createFileRequest.setProofCode(ProofV1Utils.getCode(path));
        return this.upload(createFileRequest, 0).map(createFileResponse -> {
            if (!createFileResponse.isRapidUpload()) {
                List<CreateFileResponse.PartInfo> partInfoList = createFileResponse.getPartInfoList();
                try {
                    FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);
                    LinkedList<UploadStatus> uploadStatusList = new LinkedList<UploadStatus>();
                    long position = 0L;
                    for (CreateFileResponse.PartInfo partInfo : partInfoList) {
                        uploadStatusList.add(this.upload(fileChannel, createFileRequest.getName(), partInfo, position));
                        position += this.uploadFragmentation;
                    }
                    for (int i = 0; i < this.uploadRetries; ++i) {
                        uploadStatusList.removeIf(uploadStatus -> uploadStatus.getResponseCode() == 200);
                        if (uploadStatusList.isEmpty()) break;
                        log.info("\u3010{}\u3011\u5f00\u59cb\u7b2c{}\u6b21\u91cd\u65b0\u4e0a\u4f20........", (Object)createFileRequest.getName(), (Object)(i + 1));
                        this.checkUploadStatus(uploadStatusList, fileChannel);
                    }
                    fileChannel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                CompleteRequest completeRequest = new CompleteRequest(createFileResponse.getFileId(), createFileResponse.getUploadId());
                FileEnum complete = FileEnum.COMPLETE;
                ((WebClient.RequestBodySpec)this.webClient.method(complete.getHttpMethod()).uri(complete.getApi())).bodyValue((Object)completeRequest).retrieve().toBodilessEntity().subscribe(voidResponseEntity -> {
                    if (voidResponseEntity.getStatusCode().is2xxSuccessful()) {
                        log.info("\u3010{}\u3011\u4e0a\u4f20\u6210\u529f\uff01\uff01\uff01", (Object)createFileRequest.getName());
                    }
                });
            } else {
                log.info("\u3010{}\u3011\u79d2\u4f20\u6210\u529f\uff01\uff01\uff01", (Object)createFileRequest.getName());
            }
            return createFileResponse;
        });
    }

    private void checkUploadStatus(List<UploadStatus> uploadStatusList, FileChannel fileChannel) {
        ArrayList list = new ArrayList(uploadStatusList.size());
        uploadStatusList.forEach(uploadStatus -> {
            log.error("\u3010{}\u3011\u51fa\u73b0\u9519\u8bef\u7684\u4e0a\u4f20\u5206\u7247\uff1a{} {}\n\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{uploadStatus.getFileName(), uploadStatus.getResponseCode(), uploadStatus.getResponseMessage(), uploadStatus.getErrorMessage()});
            list.add(this.upload(fileChannel, uploadStatus.getFileName(), uploadStatus.getPartInfo(), uploadStatus.getPosition()));
        });
        uploadStatusList.clear();
        uploadStatusList.addAll(list);
    }

    private UploadStatus upload(FileChannel fileChannel, String fileName, CreateFileResponse.PartInfo partInfo, long position) {
        UploadStatus uploadStatus = new UploadStatus(fileName, partInfo, position);
        try {
            HttpURLConnection connection = (HttpURLConnection)partInfo.getUploadUrl().openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            connection.setRequestProperty("Connection", "keep-alive");
            connection.setRequestProperty("Referer", "https://www.aliyundrive.com/");
            connection.setUseCaches(false);
            connection.connect();
            if (log.isDebugEnabled()) {
                log.debug("\u6587\u4ef6\u3010{}\u3011-\u5206\u7247\u3010{}\u3011\u6210\u529f\u83b7\u53d6\u8fde\u63a5", (Object)fileName, (Object)partInfo.getPartNumber());
            }
            WritableByteChannel writableByteChannel = Channels.newChannel(connection.getOutputStream());
            fileChannel.transferTo(position, this.uploadFragmentation, writableByteChannel);
            writableByteChannel.close();
            uploadStatus.setResponseCode(connection.getResponseCode());
            uploadStatus.setResponseMessage(connection.getResponseMessage());
            Optional.ofNullable(connection.getErrorStream()).ifPresent(inputStream -> {
                try {
                    uploadStatus.setErrorMessage(IoUtils.toString(inputStream));
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            if (log.isDebugEnabled()) {
                log.debug("\u6587\u4ef6\u3010{}\u3011-\u5206\u7247\u3010{}\u3011\u4e0a\u4f20\u5b8c\u6bd5", (Object)fileName, (Object)partInfo.getPartNumber());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return uploadStatus;
    }

    private Mono<CreateFileResponse> upload(CreateFileRequest createFileRequest, int i) {
        FileEnum createWithFolders = FileEnum.CREATE_WITH_FOLDERS;
        int frequency = i;
        return ((WebClient.RequestBodySpec)this.webClient.method(createWithFolders.getHttpMethod()).uri(createWithFolders.getApi())).bodyValue((Object)createFileRequest).retrieve().onStatus(httpStatus -> httpStatus.value() == 409, clientResponse -> {
            if (frequency < this.uploadRetries) {
                log.error("\u3010{}\u3011\u4e0a\u4f20\u8bf7\u6c42\u51fa\u73b0409,\u7b2c\u3010{}\u3011\u6b21\u91cd\u65b0\u8bf7\u6c42", (Object)createFileRequest.getName(), (Object)(frequency + 1));
                this.upload(createFileRequest, frequency + 1);
            }
            return clientResponse.createException();
        }).bodyToMono(CreateFileResponse.class);
    }

    @Override
    public WebClient.ResponseSpec update(UpdateRequest updateRequest) {
        FileEnum update = FileEnum.UPDATE;
        return ((WebClient.RequestBodySpec)this.webClient.method(update.getHttpMethod()).uri(update.getApi())).bodyValue((Object)updateRequest).retrieve();
    }
}

