/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.executor;

import java.io.IOException;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import xyz.xuminghai.core.ReactiveFileDao;
import xyz.xuminghai.core.ReactiveRecycleDao;
import xyz.xuminghai.executor.BlockExecutor;
import xyz.xuminghai.pojo.entity.BaseItem;
import xyz.xuminghai.pojo.enums.CheckNameEnum;
import xyz.xuminghai.pojo.request.file.CreateFolderRequest;
import xyz.xuminghai.pojo.request.file.ListRequest;
import xyz.xuminghai.pojo.request.file.SearchRequest;
import xyz.xuminghai.pojo.request.file.UpdateRequest;
import xyz.xuminghai.pojo.response.file.CreateFileResponse;
import xyz.xuminghai.pojo.response.file.CreateFolderResponse;
import xyz.xuminghai.pojo.response.file.DownloadUrlResponse;
import xyz.xuminghai.pojo.response.file.ListResponse;
import xyz.xuminghai.pojo.response.file.SearchResponse;

public class BlockBaseExecutor
implements BlockExecutor {
    private final ReactiveFileDao reactiveFileDao;
    private final ReactiveRecycleDao reactiveRecycleDao;

    public BlockBaseExecutor(ReactiveFileDao reactiveFileDao, ReactiveRecycleDao reactiveRecycleDao) {
        this.reactiveFileDao = reactiveFileDao;
        this.reactiveRecycleDao = reactiveRecycleDao;
    }

    @Override
    public ListResponse list(ListRequest listRequest) {
        return (ListResponse)this.reactiveFileDao.list(listRequest).bodyToMono(ListResponse.class).block();
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) {
        return (SearchResponse)this.reactiveFileDao.search(searchRequest).bodyToMono(SearchResponse.class).block();
    }

    @Override
    public BaseItem get(String fileId) {
        return (BaseItem)this.reactiveFileDao.get(fileId).bodyToMono(BaseItem.class).block();
    }

    @Override
    public DownloadUrlResponse getDownloadUrl(String fileId) {
        return (DownloadUrlResponse)this.reactiveFileDao.getDownloadUrl(fileId).bodyToMono(DownloadUrlResponse.class).block();
    }

    @Override
    public long downloadFile(String fileId, Path path, OpenOption ... openOptions) {
        DownloadUrlResponse downloadUrl = this.getDownloadUrl(fileId);
        try {
            URLConnection connection = downloadUrl.getUrl().openConnection();
            connection.setRequestProperty("Referer", "https://www.aliyundrive.com/");
            ReadableByteChannel readableByteChannel = Channels.newChannel(connection.getInputStream());
            String[] split = connection.getHeaderField("Content-Disposition").split("=")[1].split("''");
            String fileName = URLDecoder.decode(split[1], split[0]);
            FileChannel fileChannel = FileChannel.open(path.resolve(fileName), openOptions);
            long l = fileChannel.transferFrom(readableByteChannel, 0L, downloadUrl.getSize());
            if (l != downloadUrl.getSize()) {
                throw new IOException("\u4e0b\u8f7d\u5f02\u5e38\uff0c\u5b9e\u9645\u4e0b\u8f7d\u7684\u5b57\u8282\u548c\u6587\u4ef6\u672c\u8eab\u7684\u5b57\u8282\u4e0d\u7b26\u3002\u671f\u671b\u4e0b\u8f7d\u5b57\u8282\uff1a" + downloadUrl.getSize() + "\uff0c\u5b9e\u9645\u4e0b\u8f7d\u5b57\u8282\uff1a" + l);
            }
            readableByteChannel.close();
            fileChannel.close();
            return l;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest createFolderRequest) {
        return (CreateFolderResponse)this.reactiveFileDao.createFolder(createFolderRequest).bodyToMono(CreateFolderResponse.class).block();
    }

    @Override
    public CreateFileResponse uploadFile(String parentFileId, Path path, CheckNameEnum checkNameEnum) {
        return (CreateFileResponse)this.reactiveFileDao.uploadFile(parentFileId, path, checkNameEnum).block();
    }

    @Override
    public Boolean trash(String fileId) {
        return Boolean.TRUE.equals(this.reactiveRecycleDao.trash(fileId).toBodilessEntity().map(voidResponseEntity -> voidResponseEntity.getStatusCode().is2xxSuccessful()).block());
    }

    @Override
    public BaseItem update(UpdateRequest updateRequest) {
        return (BaseItem)this.reactiveFileDao.update(updateRequest).bodyToMono(BaseItem.class).block();
    }
}

