/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.executor;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.springframework.util.ObjectUtils;
import xyz.xuminghai.cache.Cache;
import xyz.xuminghai.executor.BlockExecutor;
import xyz.xuminghai.pojo.entity.BaseItem;
import xyz.xuminghai.pojo.enums.CheckNameEnum;
import xyz.xuminghai.pojo.request.file.CreateFolderRequest;
import xyz.xuminghai.pojo.request.file.ListRequest;
import xyz.xuminghai.pojo.request.file.SearchRequest;
import xyz.xuminghai.pojo.request.file.UpdateRequest;
import xyz.xuminghai.pojo.response.file.CreateFileResponse;
import xyz.xuminghai.pojo.response.file.CreateFolderResponse;
import xyz.xuminghai.pojo.response.file.DownloadUrlResponse;
import xyz.xuminghai.pojo.response.file.ListResponse;
import xyz.xuminghai.pojo.response.file.SearchResponse;
import xyz.xuminghai.pojo.response.file.UploadFolderResponse;

public class BlockCacheExecutor
implements BlockExecutor {
    private final Cache cache;
    private final BlockExecutor blockExecutor;

    public BlockCacheExecutor(Cache cache, BlockExecutor blockExecutor) {
        this.cache = cache;
        this.blockExecutor = blockExecutor;
    }

    @Override
    public ListResponse list(ListRequest listRequest) {
        ListResponse listResponse;
        String key = "block_list_" + listRequest.hashCode();
        Object o = this.cache.get(key);
        if (ObjectUtils.isEmpty((Object)o)) {
            listResponse = this.blockExecutor.list(listRequest);
            this.cache.put(key, listResponse);
        } else {
            listResponse = (ListResponse)o;
        }
        return listResponse;
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) {
        SearchResponse searchResponse;
        String key = "block_search_" + searchRequest.hashCode();
        Object o = this.cache.get(key);
        if (ObjectUtils.isEmpty((Object)o)) {
            searchResponse = this.blockExecutor.search(searchRequest);
            this.cache.put(key, searchResponse);
        } else {
            searchResponse = (SearchResponse)o;
        }
        return searchResponse;
    }

    @Override
    public BaseItem get(String fileId) {
        BaseItem baseItem;
        String key = "block_get_" + fileId;
        Object o = this.cache.get(key);
        if (ObjectUtils.isEmpty((Object)o)) {
            baseItem = this.blockExecutor.get(fileId);
            this.cache.put(key, baseItem);
        } else {
            baseItem = (BaseItem)o;
        }
        return baseItem;
    }

    @Override
    public DownloadUrlResponse getDownloadUrl(String fileId) {
        return this.blockExecutor.getDownloadUrl(fileId);
    }

    @Override
    public long downloadFile(String fileId, Path path, OpenOption ... openOptions) {
        return this.blockExecutor.downloadFile(fileId, path, openOptions);
    }

    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest createFolderRequest) {
        this.cache.clear();
        return this.blockExecutor.createFolder(createFolderRequest);
    }

    @Override
    public CreateFileResponse uploadFile(String parentFileId, Path path, CheckNameEnum checkNameEnum) {
        this.cache.clear();
        return this.blockExecutor.uploadFile(parentFileId, path, checkNameEnum);
    }

    @Override
    public UploadFolderResponse uploadFolder(Path path, String parentFileId, CheckNameEnum checkNameEnum) {
        this.cache.clear();
        return this.blockExecutor.uploadFolder(path, parentFileId, checkNameEnum);
    }

    @Override
    public Boolean trash(String fileId) {
        this.cache.clear();
        return this.blockExecutor.trash(fileId);
    }

    @Override
    public BaseItem update(UpdateRequest updateRequest) {
        this.cache.clear();
        return this.blockExecutor.update(updateRequest);
    }
}

