/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.executor;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.Objects;
import xyz.xuminghai.executor.Executor;
import xyz.xuminghai.pojo.entity.BaseItem;
import xyz.xuminghai.pojo.enums.CheckNameEnum;
import xyz.xuminghai.pojo.request.file.CreateFolderRequest;
import xyz.xuminghai.pojo.request.file.ListRequest;
import xyz.xuminghai.pojo.request.file.SearchRequest;
import xyz.xuminghai.pojo.request.file.UpdateRequest;
import xyz.xuminghai.pojo.response.file.CreateFileResponse;
import xyz.xuminghai.pojo.response.file.CreateFolderResponse;
import xyz.xuminghai.pojo.response.file.DownloadUrlResponse;
import xyz.xuminghai.pojo.response.file.ListResponse;
import xyz.xuminghai.pojo.response.file.SearchResponse;
import xyz.xuminghai.pojo.response.file.UploadFolderResponse;

public interface BlockExecutor
extends Executor {
    @Override
    public ListResponse list(ListRequest var1);

    @Override
    public SearchResponse search(SearchRequest var1);

    @Override
    public BaseItem get(String var1);

    @Override
    public DownloadUrlResponse getDownloadUrl(String var1);

    public long downloadFile(String var1, Path var2, OpenOption ... var3);

    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest var1);

    @Override
    public CreateFileResponse uploadFile(String var1, Path var2, CheckNameEnum var3);

    default public UploadFolderResponse uploadFolder(Path path, final String parentFileId, final CheckNameEnum checkNameEnum) {
        final UploadFolderResponse uploadFolderResponse = new UploadFolderResponse();
        try {
            Files.walkFileTree(path.toAbsolutePath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                UploadFolderResponse.Folder currentFolder = new UploadFolderResponse.Folder();
                {
                    this.currentFolder.setParentFileId(parentFileId);
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (Objects.isNull(uploadFolderResponse.getFolder())) {
                        uploadFolderResponse.setFolder(this.currentFolder);
                    } else {
                        UploadFolderResponse.Folder folder = new UploadFolderResponse.Folder();
                        folder.setParentFolder(this.currentFolder);
                        folder.setParentFileId(this.currentFolder.getFileId());
                        this.currentFolder.addFolder(folder);
                        this.currentFolder = folder;
                    }
                    CreateFolderRequest createFolderRequest = new CreateFolderRequest();
                    createFolderRequest.setParentFileId(this.currentFolder.getParentFileId());
                    createFolderRequest.setName(dir.getFileName().toString());
                    createFolderRequest.setCheckNameMode(checkNameEnum);
                    CreateFolderResponse createFolderResponse = BlockExecutor.this.createFolder(createFolderRequest);
                    this.currentFolder.setFileName(createFolderResponse.getFileName());
                    this.currentFolder.setFileId(createFolderResponse.getFileId());
                    this.currentFolder.setPath(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) {
                    UploadFolderResponse.File file = new UploadFolderResponse.File();
                    file.setParentFolder(this.currentFolder);
                    CreateFileResponse createFileResponse = BlockExecutor.this.uploadFile(this.currentFolder.getFileId(), filePath, checkNameEnum);
                    file.setParentFileId(createFileResponse.getParentFileId());
                    file.setFileId(createFileResponse.getFileId());
                    file.setFileName(createFileResponse.getFileName());
                    file.setRapidUpload(createFileResponse.isRapidUpload());
                    file.setPath(filePath);
                    file.setUploadEndTime(LocalDateTime.now());
                    this.currentFolder.addFile(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    this.currentFolder.setUploadEndTime(LocalDateTime.now());
                    this.currentFolder = this.currentFolder.getParentFolder();
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return uploadFolderResponse;
    }

    @Override
    public BaseItem update(UpdateRequest var1);

    @Override
    public Boolean trash(String var1);
}

