/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.executor;

import java.nio.file.Path;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import xyz.xuminghai.core.ReactiveFileDao;
import xyz.xuminghai.core.ReactiveRecycleDao;
import xyz.xuminghai.executor.ReactiveExecutor;
import xyz.xuminghai.pojo.entity.BaseItem;
import xyz.xuminghai.pojo.enums.CheckNameEnum;
import xyz.xuminghai.pojo.request.file.CreateFolderRequest;
import xyz.xuminghai.pojo.request.file.ListRequest;
import xyz.xuminghai.pojo.request.file.SearchRequest;
import xyz.xuminghai.pojo.request.file.UpdateRequest;
import xyz.xuminghai.pojo.response.file.CreateFileResponse;
import xyz.xuminghai.pojo.response.file.CreateFolderResponse;
import xyz.xuminghai.pojo.response.file.DownloadUrlResponse;
import xyz.xuminghai.pojo.response.file.ListResponse;
import xyz.xuminghai.pojo.response.file.SearchResponse;

public class ReactiveBaseExecutor
implements ReactiveExecutor {
    private final ReactiveFileDao reactiveFileDao;
    private final ReactiveRecycleDao reactiveRecycleDao;

    public ReactiveBaseExecutor(ReactiveFileDao reactiveFileDao, ReactiveRecycleDao reactiveRecycleDao) {
        this.reactiveFileDao = reactiveFileDao;
        this.reactiveRecycleDao = reactiveRecycleDao;
    }

    @Override
    public Mono<ResponseEntity<ListResponse>> list(ListRequest listRequest) {
        return this.reactiveFileDao.list(listRequest).toEntity(ListResponse.class);
    }

    @Override
    public Mono<ResponseEntity<SearchResponse>> search(SearchRequest searchRequest) {
        return this.reactiveFileDao.search(searchRequest).toEntity(SearchResponse.class);
    }

    @Override
    public Mono<ResponseEntity<BaseItem>> get(String fileId) {
        return this.reactiveFileDao.get(fileId).toEntity(BaseItem.class);
    }

    @Override
    public Mono<ResponseEntity<DownloadUrlResponse>> getDownloadUrl(String fileId) {
        return this.reactiveFileDao.getDownloadUrl(fileId).toEntity(DownloadUrlResponse.class);
    }

    @Override
    public Mono<ResponseEntity<CreateFolderResponse>> createFolder(CreateFolderRequest createFolderRequest) {
        return this.reactiveFileDao.createFolder(createFolderRequest).toEntity(CreateFolderResponse.class);
    }

    @Override
    public Mono<ResponseEntity<Resource>> downloadFile(String fileId, HttpHeaders httpHeaders) {
        return this.reactiveFileDao.downloadFile(fileId, httpHeaders);
    }

    @Override
    public Mono<CreateFileResponse> uploadFile(String parentFileId, Path path, CheckNameEnum checkNameEnum) {
        return this.reactiveFileDao.uploadFile(parentFileId, path, checkNameEnum);
    }

    @Override
    public Mono<ResponseEntity<Void>> trash(String fileId) {
        return this.reactiveRecycleDao.trash(fileId).toBodilessEntity();
    }

    @Override
    public Mono<ResponseEntity<BaseItem>> update(UpdateRequest updateRequest) {
        return this.reactiveFileDao.update(updateRequest).toEntity(BaseItem.class);
    }
}

