/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.executor;

import java.nio.file.Path;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Mono;
import xyz.xuminghai.cache.Cache;
import xyz.xuminghai.executor.ReactiveExecutor;
import xyz.xuminghai.pojo.entity.BaseItem;
import xyz.xuminghai.pojo.enums.CheckNameEnum;
import xyz.xuminghai.pojo.request.file.CreateFolderRequest;
import xyz.xuminghai.pojo.request.file.ListRequest;
import xyz.xuminghai.pojo.request.file.SearchRequest;
import xyz.xuminghai.pojo.request.file.UpdateRequest;
import xyz.xuminghai.pojo.response.file.CreateFileResponse;
import xyz.xuminghai.pojo.response.file.CreateFolderResponse;
import xyz.xuminghai.pojo.response.file.DownloadUrlResponse;
import xyz.xuminghai.pojo.response.file.ListResponse;
import xyz.xuminghai.pojo.response.file.SearchResponse;

public class ReactiveCacheExecutor
implements ReactiveExecutor {
    private final Cache cache;
    private final ReactiveExecutor reactiveExecutor;

    public ReactiveCacheExecutor(Cache cache, ReactiveExecutor reactiveExecutor) {
        this.cache = cache;
        this.reactiveExecutor = reactiveExecutor;
    }

    @Override
    public Mono<ResponseEntity<ListResponse>> list(ListRequest listRequest) {
        String key = "reactive_list_" + listRequest.hashCode();
        ResponseEntity listResponseEntity = (ResponseEntity)this.cache.get(key);
        Mono mono = ObjectUtils.isEmpty((Object)listResponseEntity) ? this.reactiveExecutor.list(listRequest).doOnNext(responseEntity -> this.cache.put(key, responseEntity)) : Mono.just((Object)listResponseEntity);
        return mono;
    }

    @Override
    public Mono<ResponseEntity<SearchResponse>> search(SearchRequest searchRequest) {
        String key = "reactive_search_" + searchRequest.hashCode();
        ResponseEntity searchResponseEntity = (ResponseEntity)this.cache.get(key);
        Mono mono = ObjectUtils.isEmpty((Object)searchResponseEntity) ? this.reactiveExecutor.search(searchRequest).doOnNext(responseEntity -> this.cache.put(key, responseEntity)) : Mono.just((Object)searchResponseEntity);
        return mono;
    }

    @Override
    public Mono<ResponseEntity<BaseItem>> get(String fileId) {
        String key = "reactive_get_" + fileId;
        ResponseEntity getResponseEntity = (ResponseEntity)this.cache.get(key);
        Mono mono = ObjectUtils.isEmpty((Object)getResponseEntity) ? this.reactiveExecutor.get(fileId).doOnNext(responseEntity -> this.cache.put(key, responseEntity)) : Mono.just((Object)getResponseEntity);
        return mono;
    }

    @Override
    public Mono<ResponseEntity<DownloadUrlResponse>> getDownloadUrl(String fileId) {
        return this.reactiveExecutor.getDownloadUrl(fileId);
    }

    @Override
    public Mono<ResponseEntity<Resource>> downloadFile(String fileId, HttpHeaders httpHeaders) {
        return this.reactiveExecutor.downloadFile(fileId, httpHeaders);
    }

    @Override
    public Mono<ResponseEntity<CreateFolderResponse>> createFolder(CreateFolderRequest createFolderRequest) {
        this.cache.clear();
        return this.reactiveExecutor.createFolder(createFolderRequest);
    }

    @Override
    public Mono<CreateFileResponse> uploadFile(String parentFileId, Path path, CheckNameEnum checkNameEnum) {
        this.cache.clear();
        return this.reactiveExecutor.uploadFile(parentFileId, path, checkNameEnum);
    }

    @Override
    public Mono<ResponseEntity<Void>> trash(String fileId) {
        this.cache.clear();
        return this.reactiveExecutor.trash(fileId);
    }

    @Override
    public Mono<ResponseEntity<BaseItem>> update(UpdateRequest updateRequest) {
        this.cache.clear();
        return this.reactiveExecutor.update(updateRequest);
    }
}

