/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;
import org.springframework.util.ObjectUtils;
import xyz.xuminghai.pojo.response.file.DownloadUrlResponse;

public class DownloadResource
extends InputStreamResource {
    private final URLConnection urlConnection;
    private final HttpHeaders responseHttpHeaders;
    private final DownloadUrlResponse downloadUrlResponse;

    private DownloadResource(InputStream inputStream, URLConnection urlConnection, DownloadUrlResponse downloadUrlResponse) {
        super(inputStream, "\u963f\u91cc\u4e91\u76d8\u6587\u4ef6\u4e0b\u8f7d");
        this.urlConnection = urlConnection;
        this.downloadUrlResponse = downloadUrlResponse;
        Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(headerFields.size());
        hashMap.putAll(headerFields);
        hashMap.put("HttpStatus", (List<String>)hashMap.remove(null));
        MultiValueMapAdapter multiValueMapAdapter = new MultiValueMapAdapter(hashMap);
        this.responseHttpHeaders = new HttpHeaders((MultiValueMap)multiValueMapAdapter);
    }

    public static DownloadResource createResource(DownloadUrlResponse downloadUrlResponse, HttpHeaders requestHttpHeaders) throws IOException {
        URLConnection urlConnection = downloadUrlResponse.getUrl().openConnection();
        requestHttpHeaders.forEach((key, valueList) -> valueList.forEach(value -> urlConnection.addRequestProperty((String)key, (String)value)));
        urlConnection.setRequestProperty("Referer", "https://www.aliyundrive.com/");
        return new DownloadResource(urlConnection.getInputStream(), urlConnection, downloadUrlResponse);
    }

    public long contentLength() {
        return this.downloadUrlResponse.getSize();
    }

    public HttpHeaders getResponseHttpHeaders() {
        return this.responseHttpHeaders;
    }

    @NonNull
    public URL getURL() {
        return this.urlConnection.getURL();
    }

    public HttpStatus getHttpStatus() {
        List list = this.responseHttpHeaders.get((Object)"HttpStatus");
        if (!ObjectUtils.isEmpty((Object)list)) {
            return HttpStatus.resolve((int)Integer.parseInt(((String)list.get(0)).split(" ")[1]));
        }
        return HttpStatus.OK;
    }
}

