/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.pojo.response.file;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UploadFolderResponse {
    private Folder folder;

    public Folder getFolder() {
        return this.folder;
    }

    public void setFolder(Folder folder) {
        this.folder = folder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadFolderResponse)) {
            return false;
        }
        UploadFolderResponse other = (UploadFolderResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Folder this$folder = this.getFolder();
        Folder other$folder = other.getFolder();
        return !(this$folder == null ? other$folder != null : !this$folder.equals(other$folder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadFolderResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Folder $folder = this.getFolder();
        result = result * 59 + ($folder == null ? 43 : $folder.hashCode());
        return result;
    }

    public String toString() {
        return "UploadFolderResponse(folder=" + this.getFolder() + ")";
    }

    public static final class File
    extends AbstractFile {
        private boolean rapidUpload;

        public File() {
            super("file");
        }

        public boolean isRapidUpload() {
            return this.rapidUpload;
        }

        public void setRapidUpload(boolean rapidUpload) {
            this.rapidUpload = rapidUpload;
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", File.class.getSimpleName() + "[", "]").add(super.toString()).add("rapidUpload=" + this.rapidUpload).toString();
        }
    }

    public static final class Folder
    extends AbstractFile {
        private List<Folder> folderList;
        private List<File> fileList;

        public Folder() {
            super("folder");
        }

        public List<Folder> getFolderList() {
            return this.folderList;
        }

        public void setFolderList(List<Folder> folderList) {
            this.folderList = folderList;
        }

        public List<File> getFileList() {
            return this.fileList;
        }

        public void setFileList(List<File> fileList) {
            this.fileList = fileList;
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", Folder.class.getSimpleName() + "[", "]").add(super.toString()).add("folderList.size()=" + Optional.ofNullable(this.folderList).orElse(Collections.emptyList()).size()).add("fileList.size()=" + Optional.ofNullable(this.fileList).orElse(Collections.emptyList()).size()).toString();
        }

        public void addFolder(Folder folder) {
            Objects.requireNonNull(folder, "\u6dfb\u52a0\u7684\u6587\u4ef6\u5939\u7c7b\u4e0d\u80fd\u4e3anull");
            this.folderList = Optional.ofNullable(this.folderList).orElse(new ArrayList());
            this.folderList.add(folder);
        }

        public void addFile(File file) {
            Objects.requireNonNull(file, "\u6dfb\u52a0\u7684\u6587\u4ef6\u7c7b\u4e0d\u80fd\u4e3anull");
            this.fileList = Optional.ofNullable(this.fileList).orElse(new ArrayList());
            this.fileList.add(file);
        }
    }

    private static abstract class AbstractFile
    implements Serializable {
        private final String type;
        private final LocalDateTime uploadStartTime;
        private String parentFileId;
        private String fileId;
        private String fileName;
        private Path path;
        private Folder parentFolder;
        private LocalDateTime uploadEndTime;
        private transient int parentFolderHashCode;

        protected AbstractFile(String type) {
            this.type = type;
            this.uploadStartTime = LocalDateTime.now();
        }

        public String getType() {
            return this.type;
        }

        public String getParentFileId() {
            return this.parentFileId;
        }

        public void setParentFileId(String parentFileId) {
            this.parentFileId = parentFileId;
        }

        public String getFileId() {
            return this.fileId;
        }

        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Path getPath() {
            return this.path;
        }

        public void setPath(Path path) {
            this.path = path;
        }

        public Folder getParentFolder() {
            return this.parentFolder;
        }

        public void setParentFolder(Folder parentFolder) {
            this.parentFolder = parentFolder;
            Optional.ofNullable(parentFolder).ifPresent(folder1 -> {
                this.parentFolderHashCode = folder1.hashCode();
            });
        }

        public LocalDateTime getUploadStartTime() {
            return this.uploadStartTime;
        }

        public LocalDateTime getUploadEndTime() {
            return this.uploadEndTime;
        }

        public void setUploadEndTime(LocalDateTime uploadEndTime) {
            this.uploadEndTime = uploadEndTime;
        }

        public String toString() {
            return new StringJoiner(", ", "", "").add("type='" + this.type + "'").add("parentFileId='" + this.parentFileId + "'").add("fileId='" + this.fileId + "'").add("fileName='" + this.fileName + "'").add("path=" + this.path).add("parentFolderHashCode=" + this.parentFolderHashCode).add("uploadStartTime=" + this.uploadStartTime).add("uploadEndTime=" + this.uploadEndTime).toString();
        }
    }
}

