/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Pool;
import java.util.ArrayList;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import xyz.xuminghai.serializer.Serializer;

public class KryoSerializer
implements Serializer {
    private static Class<?> ReadOnlyHttpHeadersClass;
    private static Class<?> HeadersUtils$1Class;
    private static final Pool<Kryo> KRYO_POOL;
    private static final Pool<Input> INPUT_POOL;
    private static final Pool<Output> OUTPUT_POOL;

    @Override
    public byte[] serialize(Object o) {
        if (o == null) {
            return EMPTY_ARRAY;
        }
        Output output = (Output)OUTPUT_POOL.obtain();
        ((Kryo)KRYO_POOL.obtain()).writeClassAndObject(output, o);
        byte[] bytes = output.toBytes();
        output.close();
        return bytes;
    }

    @Override
    public Object deserialize(byte[] bytes) {
        if (ObjectUtils.isEmpty((Object)bytes)) {
            return null;
        }
        Input input = (Input)INPUT_POOL.obtain();
        input.setBuffer(bytes);
        Kryo kryo = (Kryo)KRYO_POOL.obtain();
        Object o = kryo.readClassAndObject(input);
        input.close();
        return o;
    }

    static {
        try {
            ReadOnlyHttpHeadersClass = Class.forName("org.springframework.http.ReadOnlyHttpHeaders");
            HeadersUtils$1Class = Class.forName("io.netty.handler.codec.HeadersUtils$1");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        KRYO_POOL = new Pool<Kryo>(true, false, 16){

            protected Kryo create() {
                Kryo kryo = new Kryo();
                kryo.setRegistrationRequired(false);
                kryo.register(ResponseEntity.class).setInstantiator(() -> new ResponseEntity(HttpStatus.OK));
                kryo.register(ReadOnlyHttpHeadersClass).setInstantiator(HttpHeaders::new);
                kryo.register(HeadersUtils$1Class).setInstantiator(ArrayList::new);
                return kryo;
            }
        };
        INPUT_POOL = new Pool<Input>(true, false, 16){

            protected Input create() {
                return new Input();
            }
        };
        OUTPUT_POOL = new Pool<Output>(true, false, 16){

            protected Output create() {
                return new Output(1024, -1);
            }
        };
    }
}

