/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.template;

import java.nio.file.Path;
import xyz.xuminghai.cache.Cache;
import xyz.xuminghai.executor.Executor;
import xyz.xuminghai.pojo.enums.CategoryEnum;
import xyz.xuminghai.pojo.enums.CheckNameEnum;
import xyz.xuminghai.pojo.enums.OrderByEnum;
import xyz.xuminghai.pojo.enums.OrderDirectionEnum;
import xyz.xuminghai.pojo.request.file.CreateFolderRequest;
import xyz.xuminghai.pojo.request.file.ListRequest;
import xyz.xuminghai.pojo.request.file.SearchRequest;
import xyz.xuminghai.pojo.request.file.UpdateRequest;

public abstract class AbstractTemplate
implements Executor {
    public static final String DEFAULT_TOP_DIRECTORY = "root";
    private final Cache cache;

    AbstractTemplate(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public Object list() {
        return this.list(new ListRequest());
    }

    public Object list(String folderId) {
        return this.list(folderId, OrderByEnum.UPDATE_AT);
    }

    public Object list(String folderId, OrderByEnum orderByEnum) {
        return this.list(folderId, orderByEnum, OrderDirectionEnum.DESC);
    }

    public Object list(String folderId, OrderDirectionEnum orderDirectionEnum) {
        return this.list(folderId, OrderByEnum.UPDATE_AT, orderDirectionEnum);
    }

    public Object list(String folderId, OrderByEnum orderByEnum, OrderDirectionEnum orderDirectionEnum) {
        ListRequest listRequest = new ListRequest();
        listRequest.setParentFileId(folderId);
        listRequest.setOrderBy(orderByEnum);
        listRequest.setOrderDirection(orderDirectionEnum);
        return this.list(listRequest);
    }

    @Override
    public abstract Object list(ListRequest var1);

    public Object search(String fileName) {
        return this.search(fileName, CategoryEnum.ALL);
    }

    public Object search(String fileName, CategoryEnum categoryEnum) {
        return this.search(fileName, categoryEnum, OrderByEnum.UPDATE_AT, OrderDirectionEnum.DESC);
    }

    public Object search(String fileName, OrderByEnum orderByEnum, OrderDirectionEnum orderDirectionEnum) {
        return this.search(fileName, CategoryEnum.ALL, orderByEnum, orderDirectionEnum);
    }

    public Object search(String fileName, CategoryEnum categoryEnum, OrderByEnum orderByEnum, OrderDirectionEnum orderDirectionEnum) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setQuery(fileName, categoryEnum);
        searchRequest.setOrderBy(orderByEnum, orderDirectionEnum);
        return this.search(searchRequest);
    }

    @Override
    public abstract Object search(SearchRequest var1);

    @Override
    public abstract Object get(String var1);

    @Override
    public abstract Object getDownloadUrl(String var1);

    public Object createFolder(String name) {
        return this.createFolder(DEFAULT_TOP_DIRECTORY, name);
    }

    public Object createFolder(String parentFileId, String name) {
        return this.createFolder(parentFileId, name, CheckNameEnum.AUTO_RENAME);
    }

    public Object createFolder(String name, CheckNameEnum checkNameEnum) {
        return this.createFolder(DEFAULT_TOP_DIRECTORY, name, checkNameEnum);
    }

    public Object createFolder(String parentFileId, String name, CheckNameEnum checkNameEnum) {
        CreateFolderRequest createFolderRequest = new CreateFolderRequest();
        createFolderRequest.setParentFileId(parentFileId);
        createFolderRequest.setName(name);
        createFolderRequest.setCheckNameMode(checkNameEnum);
        return this.createFolder(createFolderRequest);
    }

    @Override
    public abstract Object createFolder(CreateFolderRequest var1);

    public Object uploadFile(Path path) {
        return this.uploadFile(DEFAULT_TOP_DIRECTORY, path);
    }

    public Object uploadFile(String parentFileId, Path path) {
        return this.uploadFile(parentFileId, path, CheckNameEnum.AUTO_RENAME);
    }

    public Object uploadFile(Path path, CheckNameEnum checkNameEnum) {
        return this.uploadFile(DEFAULT_TOP_DIRECTORY, path, checkNameEnum);
    }

    @Override
    public abstract Object uploadFile(String var1, Path var2, CheckNameEnum var3);

    public Object update(String fileId, String newFileName) {
        return this.update(new UpdateRequest(fileId, newFileName));
    }

    @Override
    public abstract Object update(UpdateRequest var1);

    @Override
    public abstract Object trash(String var1);
}

