/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.template;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import xyz.xuminghai.cache.Cache;
import xyz.xuminghai.core.ReactiveFileDao;
import xyz.xuminghai.core.ReactiveRecycleDao;
import xyz.xuminghai.executor.BlockBaseExecutor;
import xyz.xuminghai.executor.BlockCacheExecutor;
import xyz.xuminghai.executor.BlockExecutor;
import xyz.xuminghai.pojo.entity.BaseItem;
import xyz.xuminghai.pojo.enums.CategoryEnum;
import xyz.xuminghai.pojo.enums.CheckNameEnum;
import xyz.xuminghai.pojo.enums.OrderByEnum;
import xyz.xuminghai.pojo.enums.OrderDirectionEnum;
import xyz.xuminghai.pojo.request.file.CreateFolderRequest;
import xyz.xuminghai.pojo.request.file.ListRequest;
import xyz.xuminghai.pojo.request.file.SearchRequest;
import xyz.xuminghai.pojo.request.file.UpdateRequest;
import xyz.xuminghai.pojo.response.file.CreateFileResponse;
import xyz.xuminghai.pojo.response.file.CreateFolderResponse;
import xyz.xuminghai.pojo.response.file.DownloadUrlResponse;
import xyz.xuminghai.pojo.response.file.ListResponse;
import xyz.xuminghai.pojo.response.file.SearchResponse;
import xyz.xuminghai.pojo.response.file.UploadFolderResponse;
import xyz.xuminghai.template.AbstractTemplate;

public class BlockClientTemplate
extends AbstractTemplate {
    private final BlockExecutor blockExecutor;

    public BlockClientTemplate(Cache cache, ReactiveFileDao reactiveFileDao, ReactiveRecycleDao reactiveRecycleDao) {
        super(cache);
        BlockBaseExecutor blockBaseExecutor = new BlockBaseExecutor(reactiveFileDao, reactiveRecycleDao);
        this.blockExecutor = "NullCache".equals(cache.getName()) ? blockBaseExecutor : new BlockCacheExecutor(cache, blockBaseExecutor);
    }

    @Override
    public ListResponse list() {
        return (ListResponse)super.list();
    }

    @Override
    public ListResponse list(String folderId) {
        return (ListResponse)super.list(folderId);
    }

    @Override
    public ListResponse list(String folderId, OrderByEnum orderByEnum) {
        return (ListResponse)super.list(folderId, orderByEnum);
    }

    @Override
    public ListResponse list(String folderId, OrderDirectionEnum orderDirectionEnum) {
        return (ListResponse)super.list(folderId, orderDirectionEnum);
    }

    @Override
    public ListResponse list(String folderId, OrderByEnum orderByEnum, OrderDirectionEnum orderDirectionEnum) {
        return (ListResponse)super.list(folderId, orderByEnum, orderDirectionEnum);
    }

    @Override
    public ListResponse list(ListRequest listRequest) {
        return this.blockExecutor.list(listRequest);
    }

    @Override
    public SearchResponse search(String fileName) {
        return (SearchResponse)super.search(fileName);
    }

    @Override
    public SearchResponse search(String fileName, CategoryEnum categoryEnum) {
        return (SearchResponse)super.search(fileName, categoryEnum);
    }

    @Override
    public SearchResponse search(String fileName, OrderByEnum orderByEnum, OrderDirectionEnum orderDirectionEnum) {
        return (SearchResponse)super.search(fileName, orderByEnum, orderDirectionEnum);
    }

    @Override
    public SearchResponse search(String fileName, CategoryEnum categoryEnum, OrderByEnum orderByEnum, OrderDirectionEnum orderDirectionEnum) {
        return (SearchResponse)super.search(fileName, categoryEnum, orderByEnum, orderDirectionEnum);
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) {
        return this.blockExecutor.search(searchRequest);
    }

    @Override
    public BaseItem get(String fileId) {
        return this.blockExecutor.get(fileId);
    }

    @Override
    public DownloadUrlResponse getDownloadUrl(String fileId) {
        return this.blockExecutor.getDownloadUrl(fileId);
    }

    public long downloadFile(String fileId, Path path, OpenOption ... openOptions) {
        return this.blockExecutor.downloadFile(fileId, path, openOptions);
    }

    @Override
    public CreateFolderResponse createFolder(String name) {
        return (CreateFolderResponse)super.createFolder(name);
    }

    @Override
    public CreateFolderResponse createFolder(String parentFileId, String name) {
        return (CreateFolderResponse)super.createFolder(parentFileId, name);
    }

    @Override
    public CreateFolderResponse createFolder(String name, CheckNameEnum checkNameEnum) {
        return (CreateFolderResponse)super.createFolder(name, checkNameEnum);
    }

    @Override
    public CreateFolderResponse createFolder(String parentFileId, String name, CheckNameEnum checkNameEnum) {
        return (CreateFolderResponse)super.createFolder(parentFileId, name, checkNameEnum);
    }

    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest createFolderRequest) {
        return this.blockExecutor.createFolder(createFolderRequest);
    }

    @Override
    public CreateFileResponse uploadFile(Path path) {
        return (CreateFileResponse)super.uploadFile(path);
    }

    @Override
    public CreateFileResponse uploadFile(String parentFileId, Path path) {
        return (CreateFileResponse)super.uploadFile(parentFileId, path);
    }

    @Override
    public CreateFileResponse uploadFile(Path path, CheckNameEnum checkNameEnum) {
        return (CreateFileResponse)super.uploadFile(path, checkNameEnum);
    }

    @Override
    public CreateFileResponse uploadFile(String parentFileId, Path path, CheckNameEnum checkNameEnum) {
        return this.blockExecutor.uploadFile(parentFileId, path, checkNameEnum);
    }

    public UploadFolderResponse uploadFolder(Path path) {
        return this.uploadFolder("root", path);
    }

    public UploadFolderResponse uploadFolder(String parentFileId, Path path) {
        return this.uploadFolder(parentFileId, path, CheckNameEnum.AUTO_RENAME);
    }

    public UploadFolderResponse uploadFolder(Path path, CheckNameEnum checkNameEnum) {
        return this.uploadFolder("root", path, checkNameEnum);
    }

    public UploadFolderResponse uploadFolder(String parentFileId, Path path, CheckNameEnum checkNameEnum) {
        return this.blockExecutor.uploadFolder(path, parentFileId, checkNameEnum);
    }

    @Override
    public BaseItem update(String fileId, String newFileName) {
        return (BaseItem)super.update(fileId, newFileName);
    }

    @Override
    public BaseItem update(UpdateRequest updateRequest) {
        return this.blockExecutor.update(updateRequest);
    }

    @Override
    public Boolean trash(String fileId) {
        return this.blockExecutor.trash(fileId);
    }
}

