/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.template;

import java.nio.file.Path;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import xyz.xuminghai.cache.Cache;
import xyz.xuminghai.core.ReactiveFileDao;
import xyz.xuminghai.core.ReactiveRecycleDao;
import xyz.xuminghai.executor.ReactiveBaseExecutor;
import xyz.xuminghai.executor.ReactiveCacheExecutor;
import xyz.xuminghai.executor.ReactiveExecutor;
import xyz.xuminghai.pojo.entity.BaseItem;
import xyz.xuminghai.pojo.enums.CategoryEnum;
import xyz.xuminghai.pojo.enums.CheckNameEnum;
import xyz.xuminghai.pojo.enums.OrderByEnum;
import xyz.xuminghai.pojo.enums.OrderDirectionEnum;
import xyz.xuminghai.pojo.request.file.CreateFolderRequest;
import xyz.xuminghai.pojo.request.file.ListRequest;
import xyz.xuminghai.pojo.request.file.SearchRequest;
import xyz.xuminghai.pojo.request.file.UpdateRequest;
import xyz.xuminghai.pojo.response.file.CreateFileResponse;
import xyz.xuminghai.pojo.response.file.CreateFolderResponse;
import xyz.xuminghai.pojo.response.file.DownloadUrlResponse;
import xyz.xuminghai.pojo.response.file.ListResponse;
import xyz.xuminghai.pojo.response.file.SearchResponse;
import xyz.xuminghai.template.AbstractTemplate;

public class ReactiveClientTemplate
extends AbstractTemplate {
    private final ReactiveExecutor reactiveExecutor;

    public ReactiveClientTemplate(Cache cache, ReactiveFileDao reactiveFileDao, ReactiveRecycleDao reactiveRecycleDao) {
        super(cache);
        ReactiveBaseExecutor reactiveBaseExecutor = new ReactiveBaseExecutor(reactiveFileDao, reactiveRecycleDao);
        this.reactiveExecutor = "NullCache".equals(cache.getName()) ? reactiveBaseExecutor : new ReactiveCacheExecutor(cache, reactiveBaseExecutor);
    }

    public Mono<ResponseEntity<ListResponse>> list() {
        return (Mono)super.list();
    }

    public Mono<ResponseEntity<ListResponse>> list(String folderId) {
        return (Mono)super.list(folderId);
    }

    public Mono<ResponseEntity<ListResponse>> list(String folderId, OrderByEnum orderByEnum) {
        return (Mono)super.list(folderId, orderByEnum);
    }

    public Mono<ResponseEntity<ListResponse>> list(String folderId, OrderDirectionEnum orderDirectionEnum) {
        return (Mono)super.list(folderId, orderDirectionEnum);
    }

    public Mono<ResponseEntity<ListResponse>> list(String folderId, OrderByEnum orderByEnum, OrderDirectionEnum orderDirectionEnum) {
        return (Mono)super.list(folderId, orderByEnum, orderDirectionEnum);
    }

    public Mono<ResponseEntity<ListResponse>> list(ListRequest listRequest) {
        return this.reactiveExecutor.list(listRequest);
    }

    public Mono<ResponseEntity<SearchResponse>> search(String fileName) {
        return (Mono)super.search(fileName);
    }

    public Mono<ResponseEntity<SearchResponse>> search(String fileName, CategoryEnum categoryEnum) {
        return (Mono)super.search(fileName, categoryEnum);
    }

    public Mono<ResponseEntity<SearchResponse>> search(String fileName, OrderByEnum orderByEnum, OrderDirectionEnum orderDirectionEnum) {
        return (Mono)super.search(fileName, orderByEnum, orderDirectionEnum);
    }

    public Mono<ResponseEntity<SearchResponse>> search(String fileName, CategoryEnum categoryEnum, OrderByEnum orderByEnum, OrderDirectionEnum orderDirectionEnum) {
        return (Mono)super.search(fileName, categoryEnum, orderByEnum, orderDirectionEnum);
    }

    public Mono<ResponseEntity<SearchResponse>> search(SearchRequest searchRequest) {
        return this.reactiveExecutor.search(searchRequest);
    }

    public Mono<ResponseEntity<BaseItem>> get(String fileId) {
        return this.reactiveExecutor.get(fileId);
    }

    public Mono<ResponseEntity<DownloadUrlResponse>> getDownloadUrl(String fileId) {
        return this.reactiveExecutor.getDownloadUrl(fileId);
    }

    public Mono<ResponseEntity<Resource>> downloadFile(String fileId, HttpHeaders httpHeaders) {
        return this.reactiveExecutor.downloadFile(fileId, httpHeaders);
    }

    public Mono<ResponseEntity<CreateFolderResponse>> createFolder(String name) {
        return (Mono)super.createFolder(name);
    }

    public Mono<ResponseEntity<CreateFolderResponse>> createFolder(String parentFileId, String name) {
        return (Mono)super.createFolder(parentFileId, name);
    }

    public Mono<ResponseEntity<CreateFolderResponse>> createFolder(String name, CheckNameEnum checkNameEnum) {
        return (Mono)super.createFolder(name, checkNameEnum);
    }

    public Mono<ResponseEntity<CreateFolderResponse>> createFolder(String parentFileId, String name, CheckNameEnum checkNameEnum) {
        return (Mono)super.createFolder(parentFileId, name, checkNameEnum);
    }

    public Mono<ResponseEntity<CreateFolderResponse>> createFolder(CreateFolderRequest createFolderRequest) {
        return this.reactiveExecutor.createFolder(createFolderRequest);
    }

    public Mono<CreateFileResponse> uploadFile(Path path) {
        return (Mono)super.uploadFile(path);
    }

    public Mono<CreateFileResponse> uploadFile(String parentFileId, Path path) {
        return (Mono)super.uploadFile(parentFileId, path);
    }

    public Mono<CreateFileResponse> uploadFile(Path path, CheckNameEnum checkNameEnum) {
        return (Mono)super.uploadFile(path, checkNameEnum);
    }

    public Mono<CreateFileResponse> uploadFile(String parentFileId, Path path, CheckNameEnum checkNameEnum) {
        return this.reactiveExecutor.uploadFile(parentFileId, path, checkNameEnum);
    }

    public Mono<ResponseEntity<BaseItem>> update(String fileId, String newFileName) {
        return (Mono)super.update(fileId, newFileName);
    }

    public Mono<ResponseEntity<BaseItem>> update(UpdateRequest updateRequest) {
        return this.reactiveExecutor.update(updateRequest);
    }

    public Mono<ResponseEntity<Void>> trash(String fileId) {
        return this.reactiveExecutor.trash(fileId);
    }
}

