/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.util;

import java.time.Duration;
import java.time.temporal.Temporal;

public final class DurationUtils {
    private DurationUtils() {
    }

    public static String between(Temporal startInclusive, Temporal endExclusive) {
        long seconds;
        long minutes;
        long hours;
        Duration between = Duration.between(startInclusive, endExclusive);
        if (between.isNegative()) {
            throw new IllegalArgumentException("\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (between.isZero()) {
            return "0\u6beb\u79d2";
        }
        StringBuilder sb = new StringBuilder();
        long days = between.toDays();
        if (days > 0L) {
            sb.append(days).append("\u5929\uff0c");
        }
        if ((hours = between.toHours()) > 0L) {
            sb.append(hours % 24L).append("\u5c0f\u65f6\uff0c");
        }
        if ((minutes = between.toMinutes()) > 0L) {
            sb.append(minutes % 60L).append("\u5206\u949f\uff0c");
        }
        if ((seconds = between.getSeconds()) > 0L) {
            sb.append(seconds % 60L).append("\u79d2\uff0c");
        }
        long millis = between.getNano() / 1000000;
        sb.append(millis).append("\u6beb\u79d2");
        if (millis == 0L) {
            sb.append("\uff0c").append(between.getNano() % 1000000).append("\u7eb3\u79d2");
        }
        return sb.toString();
    }
}

