/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.xuminghai.exception.UnsupportedSystemException;
import xyz.xuminghai.util.IoUtils;

public final class HashUtils {
    private static final Logger log = LoggerFactory.getLogger(HashUtils.class);
    private static final List<String> LIST = new ArrayList<String>(3){
        {
            this.add("Windows");
            this.add("Linux");
            this.add("Mac");
        }
    };
    private static final String SYSTEM_NAME = System.getProperty("os.name");

    private HashUtils() {
    }

    public static String sha1(Path path) {
        HashUtils.checkFile(Objects.requireNonNull(path, "path \u4e3a null"));
        log.info("\u5f00\u59cb\u8ba1\u7b97\u3010{}\u3011\u7684hash", (Object)path.getFileName());
        if (SYSTEM_NAME.contains(LIST.get(0))) {
            return HashUtils.windowsSha1(path.toAbsolutePath().toString()).toUpperCase(Locale.ROOT);
        }
        if (SYSTEM_NAME.contains(LIST.get(1))) {
            return HashUtils.linuxSha1(path.toAbsolutePath().toString()).toUpperCase(Locale.ROOT);
        }
        if (SYSTEM_NAME.contains(LIST.get(2))) {
            return HashUtils.macSha1(path.toAbsolutePath().toString()).toUpperCase(Locale.ROOT);
        }
        throw new UnsupportedSystemException("\u5f53\u524d\u64cd\u4f5c\u7cfb\u7edf\u8fd8\u4e0d\u652f\u6301");
    }

    public static String md5(Path path) {
        HashUtils.checkFile(path);
        if (SYSTEM_NAME.contains(LIST.get(0))) {
            return HashUtils.windowsMd5(path.toAbsolutePath().toString()).toUpperCase(Locale.ROOT);
        }
        if (SYSTEM_NAME.contains(LIST.get(1))) {
            return HashUtils.linuxMd5(path.toAbsolutePath().toString()).toUpperCase(Locale.ROOT);
        }
        if (SYSTEM_NAME.contains(LIST.get(2))) {
            return HashUtils.macMd5(path.toAbsolutePath().toString()).toUpperCase(Locale.ROOT);
        }
        throw new UnsupportedSystemException("\u5f53\u524d\u64cd\u4f5c\u7cfb\u7edf\u8fd8\u4e0d\u652f\u6301");
    }

    private static void checkFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("\u8fd9\u4e2a\u8def\u5f84\u4e0d\u662f\u6587\u4ef6\uff1a" + path);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileSystemNotFoundException("\u6ca1\u6709\u627e\u5230\u8fd9\u4e2a\u6587\u4ef6\uff1a" + path);
        }
        try {
            if (Files.size(path) == 0L) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u6587\u4ef6\u5927\u5c0f\u4e3a0\u4e2a\u5b57\u8282\uff1a" + path);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> supportedSystem() {
        return LIST;
    }

    private static String windowsSha1(String path) {
        ProcessBuilder processBuilder = new ProcessBuilder("CertUtil", "-hashfile", path, "SHA1");
        return HashUtils.windowsExecute(processBuilder);
    }

    private static String windowsMd5(String path) {
        ProcessBuilder processBuilder = new ProcessBuilder("CertUtil", "-hashfile", path, "MD5");
        return HashUtils.windowsExecute(processBuilder);
    }

    private static String windowsExecute(ProcessBuilder processBuilder) {
        try {
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            String string = IoUtils.toString(IoUtils.printlnResetOrPushback(inputStream, Charset.forName("GBK")), Charset.forName("GBK"));
            inputStream.close();
            return string.split("\u54c8\u5e0c:")[1].split("CertUtil:")[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String linuxSha1(String path) {
        return "";
    }

    private static String linuxMd5(String path) {
        return "";
    }

    private static String macSha1(String path) {
        return "";
    }

    private static String macMd5(String path) {
        return "";
    }
}

