/*
 * Decompiled with CFR 0.152.
 */
package xyz.xuminghai.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IoUtils {
    private static final Logger log = LoggerFactory.getLogger(IoUtils.class);

    private IoUtils() {
    }

    public static String toString(InputStream inputStream, Charset charset) {
        if (inputStream == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        bufferedReader.lines().forEach(stringWriter::write);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static InputStream printlnPushback(InputStream inputStream, Charset charset) {
        String string = IoUtils.toString(inputStream, charset);
        byte[] bytes = string.getBytes(charset);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, bytes.length);
        log.info(string);
        try {
            pushbackInputStream.unread(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pushbackInputStream;
    }

    public static InputStream printlnPushback(InputStream inputStream) {
        return IoUtils.printlnPushback(inputStream, Charset.defaultCharset());
    }

    public static InputStream printlnResetOrPushback(InputStream inputStream, Charset charset) {
        if (inputStream.markSupported()) {
            log.info("\u8fd9\u4e2a\u8f93\u5165\u6d41\u652f\u6301Mark");
            inputStream.mark(0);
            log.info(IoUtils.toString(inputStream, charset));
            try {
                inputStream.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return inputStream;
        }
        return IoUtils.printlnPushback(inputStream, charset);
    }

    public static InputStream printlnResetOrPushback(InputStream inputStream) {
        return IoUtils.printlnResetOrPushback(inputStream, Charset.defaultCharset());
    }

    public static String toString(InputStream inputStream) {
        return IoUtils.toString(inputStream, Charset.defaultCharset());
    }

    public static List<String> lines(InputStream inputStream, Charset charset) {
        if (inputStream == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        bufferedReader.lines().forEach(list::add);
        return list;
    }

    public static List<String> lines(InputStream inputStream) {
        return IoUtils.lines(inputStream, Charset.defaultCharset());
    }
}

