/*
 * Decompiled with CFR 0.152.
 */
package young.httpd.processor;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import young.httpd.annotation.PathVariable;
import young.httpd.annotation.RequestHeader;
import young.httpd.annotation.RequestMapping;
import young.httpd.annotation.RequestParam;
import young.httpd.exception.NotFoundException;
import young.httpd.handler.HttpdHandler;

@AutoService(value={Processor.class})
public class HttpdProcessor
extends AbstractProcessor {
    private static final String CLASS_NAME = "GeneratedHttpdHandlerImpl";
    private static final String PACKAGE_NAME = "young.httpd";
    private static final String METHOD_DISPOSE_REQUEST = "disposeRequest";
    private static final String VOID = "void";
    private static final List<Integer> HASHS = new ArrayList<Integer>();
    private MethodSpec.Builder mDisposeRequest;
    private MethodSpec.Builder mConstructor;
    private TypeSpec.Builder mTypeSpec;

    private static final int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.mDisposeRequest = MethodSpec.methodBuilder((String)METHOD_DISPOSE_REQUEST).addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, "url", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), "params", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), "files", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), "paths", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), "headers", new Modifier[0]).beginControlFlow("switch (hash(url))", new Object[0]).returns(Object.class);
        this.mConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.mTypeSpec = TypeSpec.classBuilder((String)CLASS_NAME).addModifiers(new Modifier[]{Modifier.FINAL}).superclass(HttpdHandler.class).addJavadoc("Generated code, do not modify.", new Object[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{$S, $S}", new Object[]{"deprecation", "unchecked"}).build());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)RequestMapping.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.fatalError(writer.toString());
            return true;
        }
    }

    private boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws IOException {
        this.processRequestMapping(annotations, roundEnv);
        if (annotations.size() > 0) {
            this.mTypeSpec.addMethod(this.mConstructor.build());
            this.mDisposeRequest.endControlFlow();
            this.mDisposeRequest.addStatement("throw new $T()", new Object[]{NotFoundException.class});
            this.mTypeSpec.addMethod(this.mDisposeRequest.build());
            JavaFile.builder((String)PACKAGE_NAME, (TypeSpec)this.mTypeSpec.build()).build().writeTo(this.processingEnv.getFiler());
        }
        return true;
    }

    private void processRequestMapping(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(RequestMapping.class);
        for (Element element : elements) {
            try {
                switch (element.getKind()) {
                    case METHOD: {
                        this.handleMethod(element);
                        break;
                    }
                    case CLASS: {
                        this.handleClass(element);
                    }
                }
            }
            catch (Exception e) {}
        }
    }

    private void handleClass(Element element) throws Exception {
        if (element.getKind() != ElementKind.CLASS) {
            throw new Exception();
        }
        TypeElement typeElement = (TypeElement)element;
        String var = this.generateVariable(typeElement.getQualifiedName().toString());
        TypeName typeName = TypeName.get((TypeMirror)typeElement.asType());
        this.mTypeSpec.addField(typeName, var, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        this.mConstructor.addStatement(var + " = new $T()", new Object[]{typeName});
    }

    private void handleMethod(Element element) throws Exception {
        if (element.getKind() != ElementKind.METHOD) {
            throw new Exception();
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new Exception();
        }
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        RequestMapping executableMapping = executableElement.getAnnotation(RequestMapping.class);
        RequestMapping typeMapping = typeElement.getAnnotation(RequestMapping.class);
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(typeMapping.value()).append("/").append(executableMapping.value());
        List<? extends VariableElement> parameters = executableElement.getParameters();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        String r = executableElement.getReturnType().toString().toLowerCase();
        if (!VOID.equals(r)) {
            sb.append("case $N: return $N.$L(");
        } else {
            sb.append("case $N: $N.$L(");
        }
        String urlVarName = this.generateVariable(typeElement.getQualifiedName().toString() + "_" + executableElement.getSimpleName().toString()).toUpperCase();
        for (int i = 0; i < parameters.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            VariableElement variableElement = parameters.get(i);
            ClassName className = null;
            TypeName typeName = null;
            try {
                className = ClassName.bestGuess((String)variableElement.asType().toString().replaceAll("<.+>", ""));
            }
            catch (Exception e) {
                typeName = ClassName.get((TypeMirror)variableElement.asType());
            }
            urlVarName = urlVarName + "_" + (className != null ? className.simpleName() : typeName.toString());
            RequestParam requestParam = variableElement.getAnnotation(RequestParam.class);
            if (requestParam != null) {
                sb.append("getRequestParam($S, params, files, $T.class)");
                list.add(requestParam.value());
                list.add((String)(className == null ? typeName : className));
                continue;
            }
            PathVariable pathVariable = variableElement.getAnnotation(PathVariable.class);
            if (pathVariable != null) {
                sb.append("getPathVariable($S, paths, $T.class)");
                list.add(pathVariable.value());
                list.add((String)(className == null ? typeName : className));
                continue;
            }
            RequestHeader requestHeader = variableElement.getAnnotation(RequestHeader.class);
            if (requestHeader != null) {
                sb.append("getRequestHeader($S, headers, $T.class)");
                list.add(requestHeader.value());
                list.add((String)(className == null ? typeName : className));
                continue;
            }
            sb.append("getInject($T.class)");
            list.add((String)(className == null ? typeName : className));
        }
        if (VOID.equals(r)) {
            sb.append("); return null");
        } else {
            sb.append(")");
        }
        String url = builder.toString().replaceAll("/+", "/").replaceAll("^/|/$", "");
        int hashCode = HttpdProcessor.hash(url);
        if (HASHS.contains(hashCode)) {
            this.fatalError(" mapping: " + url + " repetitive!");
        }
        HASHS.add(hashCode);
        String name = urlVarName.toUpperCase();
        this.mTypeSpec.addField(FieldSpec.builder(Integer.TYPE, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{hashCode}).build());
        this.mConstructor.addStatement("registerUrl($S)", new Object[]{url});
        String classVar = this.generateVariable(typeElement.getQualifiedName().toString());
        String methodName = executableElement.getSimpleName().toString();
        list.add(0, methodName);
        list.add(0, classVar);
        list.add(0, name);
        this.mDisposeRequest.addStatement(sb.toString(), list.toArray(new Object[0]));
    }

    private String generateVariable(String str) {
        if (str == null || str.length() <= 0) {
            return "";
        }
        return str.replaceAll("\\.|/", "_").toLowerCase();
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }
}

