package zeiss.gesture;

/**
 * Created by dennis on 30/9/16.
 */
/*
 * Copyright (C) 2015 Jared Rummler
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import android.util.Log;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * Gives access to the system properties store. The system properties store contains a list of
 * string key-value pairs.
 */
public class SystemProperties {
    private static String TAG = SystemProperties.class.getSimpleName()+" SystemPropertiesSystemPropertiesSystemPropertiesSystemProperties == ";
//    private static final Class<?> SP = getSystemPropertiesClass();
//
//    /**
//     * Get the value for the given key.
//     */
//    public static String get(String key) {
//        try {
//            return (String) SP.getMethod("get", String.class).invoke(null, key);
//        } catch (Exception e) {
//            return null;
//        }
//    }
//
//    /**
//     * Get the value for the given key.
//     *
//     * @return if the key isn't found, return def if it isn't null, or an empty string otherwise
//     */
//    public static String get(String key, String def) {
//        try {
//            return (String) SP.getMethod("get", String.class, String.class).invoke(null, key, def);
//        } catch (Exception e) {
//            return def;
//        }
//    }
//
//    /**
//     * Get the value for the given key, returned as a boolean. Values 'n', 'no', '0', 'false' or
//     * 'off' are considered false. Values 'y', 'yes', '1', 'true' or 'on' are considered true. (case
//     * sensitive). If the key does not exist, or has any other value, then the default result is
//     * returned.
//     *
//     * @param key
//     *     the key to lookup
//     * @param def
//     *     a default value to return
//     * @return the key parsed as a boolean, or def if the key isn't found or is not able to be
//     * parsed as a boolean.
//     */
//    public static boolean getBoolean(String key, boolean def) {
//        try {
//            return (Boolean) SP.getMethod("getBoolean", String.class, boolean.class)
//                    .invoke(null, key, def);
//        } catch (Exception e) {
//            return def;
//        }
//    }
//
//    /**
//     * Get the value for the given key, and return as an integer.
//     *
//     * @param key
//     *     the key to lookup
//     * @param def
//     *     a default value to return
//     * @return the key parsed as an integer, or def if the key isn't found or cannot be parsed
//     */
//    public static int getInt(String key, int def) {
//        try {
//            return (Integer) SP.getMethod("getInt", String.class, int.class).invoke(null, key, def);
//        } catch (Exception e) {
//            return def;
//        }
//    }
//
//    /**
//     * Get the value for the given key, and return as a long.
//     *
//     * @param key
//     *     the key to lookup
//     * @param def
//     *     a default value to return
//     * @return the key parsed as a long, or def if the key isn't found or cannot be parsed
//     */
//    public static long getLong(String key, long def) {
//        try {
//            return (Long) SP.getMethod("getLong", String.class, long.class).invoke(null, key, def);
//        } catch (Exception e) {
//            return def;
//        }
//    }
//
//    /**
//     * Set the value for the given key.
//     * <p/>
//     * <b>NOTE:</b> app processes do not have the privilege to write system properties. You will
//     * need to be the system or root user to set a system property.
//     *
//     * @throws IllegalArgumentException
//     *     if the key exceeds 32 characters
//     * @throws IllegalArgumentException
//     *     if the value exceeds 92 characters
//     */
//    public static void set(String key, String val) {
//        try {
//            SP.getMethod("set", String.class, String.class).invoke(null, key, val);
//            Log.e(TAG,"set: key = "+key+" val = "+val+"");
//        } catch (Exception ignored) {
//            Log.e(TAG,"set: key = "+key+" val = "+val+" / ignored = "+ignored.toString());
//        }
//    }
//
//    private static Class<?> getSystemPropertiesClass() {
//        try {
//            return Class.forName("android.os.SystemProperties");
//        } catch (ClassNotFoundException shouldNotHappen) {
//            return null;
//        }
//    }
//
//    private SystemProperties() {
//        throw new AssertionError();
//    }

    private static Method sysPropGet;
    private static Method sysPropSet;

    static {
        try {
            Class<?> S = Class.forName("android.os.SystemProperties");
            Method M[] = S.getMethods();
            for (Method m : M) {
                String n = m.getName();
                if (n.equals("get")) {
                    sysPropGet = m;
                } else if (n.equals("set")) {
                    sysPropSet = m;
                }
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String get(String name, String default_value) {
        try {
            return (String) sysPropGet.invoke(null, name, default_value);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return default_value;
    }

    public static void set(String name, String value) {
        Log.e(TAG,"set: name = "+name+" value = "+value);
        try {
            sysPropSet.invoke(null, name, value);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            Log.e(TAG,"e = "+e.toString());
        } catch (IllegalAccessException e) {
            e.printStackTrace();
            Log.e(TAG,"e = "+e.toString());
        } catch (InvocationTargetException e) {
            //java.lang.reflect.InvocationTargetException
            e.printStackTrace();
            Log.e(TAG,"e = "+e.toString());
        }
    }
}