package zeiss.gesture.detector;

import android.content.Context;
import android.view.ScaleGestureDetector;

import zeiss.gesture.listener.ZeissScaleGestureListener;

/**
 * Created by dennis on 13/9/16.
 */
public class ZeissGestureScaleDetector extends ScaleGestureDetector {
    private ZeissScaleGestureListener mZeissScaleGestureListener;
    public ZeissGestureScaleDetector(Context context, ZeissScaleGestureListener listener) {
        super(context, listener);
        mZeissScaleGestureListener = listener;
    }

    public  void setOnScaleListener(OnScaleListener listener){
        mZeissScaleGestureListener.setOnScaleListener(listener);
    }
    public  void setOnScaleRange(int min,int max){
        mZeissScaleGestureListener.setScaleRange(min,max);
    }

    public ZeissScaleGestureListener getZeissScaleGestureListener() {
        return mZeissScaleGestureListener;
    }


    public interface OnScaleListener {
        void onScaleGesture(ScaleGestureDetector detector,float scaleFactor);
    }
}
