package zeiss.gesture.listener;

import android.view.ScaleGestureDetector;

import zeiss.gesture.detector.ZeissGestureScaleDetector;

/**
 * Created by Flame on 19/7/16.
 */
public class ZeissScaleGestureListener extends ScaleGestureDetector.SimpleOnScaleGestureListener {

    private float DEFAULT_MIN = 0.1f;
    private float DEFAULT_MAX = 10.0f;
    private float DEFAULT_FACTOR = 10.0f;

    private  ZeissGestureScaleDetector.OnScaleListener mOnScaleListener;
    private float mScaleFactor = DEFAULT_FACTOR;
    private float min = DEFAULT_MIN ,max = DEFAULT_MAX;

    public ZeissScaleGestureListener(){

    }
    public ZeissScaleGestureListener(ZeissGestureScaleDetector.OnScaleListener mListener) {
        this.mOnScaleListener = mListener;
    }

    public ZeissGestureScaleDetector.OnScaleListener getOnScaleListener() {
        return mOnScaleListener;
    }

    public void setOnScaleListener(ZeissGestureScaleDetector.OnScaleListener mListener) {
        this.mOnScaleListener = mListener;
    }

    @Override
    public boolean onScale(ScaleGestureDetector detector) {
            mScaleFactor *= detector.getScaleFactor();
            mScaleFactor = Math.max(min, Math.min(mScaleFactor, max));
//            Log.e("DEBUG", "Scale:" + mScaleFactor+" / ScaleFactor = "+detector.getScaleFactor());
            if (mOnScaleListener != null) {
                mOnScaleListener.onScaleGesture(detector,mScaleFactor);
            }
            return true;
    }

    public void reset(){
        mScaleFactor = DEFAULT_FACTOR;
    }
    public void setScaleRange(float min,float max){
        this.min = min;
        this.max = max;
    }


}
