package zeiss.gesture.listener;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;

import java.util.concurrent.atomic.AtomicBoolean;

import zeiss.gesture.Util;
import zeiss.gesture.callback.ZeissGestureSystemCallBack;
import zeiss.gesture.detector.ZeissGestureTouchDetector;

/**
 * Created by dennis on 13/9/16.
 */
public class ZeissTouchGestureListener extends ZeissGestureTouchDetector.SystemGestureListener implements GestureDetector.OnGestureListener,
        GestureDetector.OnDoubleTapListener {

    public final String TAG = ZeissTouchGestureListener.class.getSimpleName();

    public static final int TAP = 0;
    public static final int DOUBLE_TAP = 1;
    public static final int PRESS = 2;
    public static final int TRIPLE_TAP = 3;

    public static final long DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
    public static final long LONG_PRESS_TIMEOUT = 1000;//ViewConfiguration.getLongPressTimeout();
    public static final int SWIPE_THRESHOLD = 200;
    public static final int SWIPE_VELOCITY_THRESHOLD = 500;
    public static final float SCROLL_THRESHOLD = 50;
    public static final int SINGLE_TAPX_THRESHOLD = 50;
    public static final int SINGLE_TAPY_THRESHOLD = 25;
    public static float mViewScaledTouchSlop;

    private MotionEvent mCurrentDownEvent;
    private MotionEvent mRealEvent;


    private int mPtrCount = 0;

    private float mPrimStartTouchEventX = 0;
    private float mPrimStartTouchEventY = 0;
    private float mSecStartTouchEventX = 0;
    private float mSecStartTouchEventY = 0;
    private float mPrimSecStartTouchDistance = 0;

    private long downTimestamp = System.currentTimeMillis();

    private AtomicBoolean mIsLongPress = new AtomicBoolean();


    private boolean mIsScrolling = false;
    private boolean isSingleTouch = false;

    private class GestureHandler extends Handler {

        GestureHandler() {
            super();
        }

        GestureHandler(Handler handler) {
            super(handler.getLooper());
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case TAP:
                    Log("TAP Finger Count "+mCurrentDownEvent.getPointerCount());
                    onSingleTapConfirmed(mCurrentDownEvent);
                    break;
                case DOUBLE_TAP:
                    Log("Double Tap "+mCurrentDownEvent.getPointerCount());
                    onDoubleTapConfirmed(mCurrentDownEvent);
                    break;
                case TRIPLE_TAP:
                    Log("Triple Tap "+mCurrentDownEvent.getPointerCount());
                    onTripleTapConfirmed(mCurrentDownEvent);
                    break;
                case PRESS:
                    Log("PRESS "+mCurrentDownEvent.getPointerCount());
                    //onLongPress(mCurrentDownEvent);
                    onZeissLongPress(mCurrentDownEvent);
                    break;
                default:
                    throw new RuntimeException("Unknown message " + msg); // never
            }
        }
    }

    GestureHandler mHandler;

    public ZeissTouchGestureListener(View view, ZeissGestureSystemCallBack systemCallBack) {
        super(view,systemCallBack);
        mHandler = new GestureHandler();
        final ViewConfiguration viewConfig = ViewConfiguration.get(view.getContext());
        mViewScaledTouchSlop = viewConfig.getScaledTouchSlop();
    }
    public boolean onTouchEvent(MotionEvent ev) {

        if(mOnTouchListener!=null) {
            if(mOnTouchListener.onTouchEvent(ev)){
                return true;
            }
        }
        int action = (ev.getAction() & MotionEvent.ACTION_MASK);

        switch (action) {
            case MotionEvent.ACTION_POINTER_DOWN:
                isSingleTouch = false;
                Log("onTouchEvent ACTION_POINTER_DOWN");
                mPtrCount++;
                if (ev.getPointerCount() > 1) {
                    mSecStartTouchEventX = ev.getX(1);
                    mSecStartTouchEventY = ev.getY(1);
                    mPrimSecStartTouchDistance = distance(ev, 0, 1);

                    if (mCurrentDownEvent != null) {
                        mCurrentDownEvent.recycle();
                    }
                    mCurrentDownEvent = MotionEvent.obtain(ev);
                    if(mRealEvent !=null){
                        mRealEvent.recycle();
                    }
                    mRealEvent = MotionEvent.obtain(ev);
//                    mRealEvent.getX

                    if(mHandler.hasMessages(PRESS)) {
                        mHandler.removeMessages(PRESS);
                    }
                    mHandler.sendEmptyMessageDelayed(PRESS, LONG_PRESS_TIMEOUT);


                    return true;
                }
                break;
            case MotionEvent.ACTION_POINTER_UP:
                Log("onTouchEvent ACTION_POINTER_UP");
                actionUp(ev);

                break;
            case MotionEvent.ACTION_DOWN:
                isSingleTouch = true;
                Log("onTouchEvent ACTION_DOWN");
                mPtrCount++;
                if(getOnScrollListener()!=null){
                   getOnScrollListener().onStart(ev);
                }
                if(mHandler.hasMessages(PRESS)) {
                    mHandler.removeMessages(PRESS);
                }
                mHandler.sendEmptyMessageDelayed(PRESS, LONG_PRESS_TIMEOUT);
                break;
            case MotionEvent.ACTION_UP:
//                Log("onTouchEvent ACTION_UP");
                if(isSingleTouch) {
                    actionUp(ev);
                }
                break;
            case MotionEvent.ACTION_MOVE:
                if(mHandler.hasMessages(PRESS) && isMove(mPrimStartTouchEventX, mPrimStartTouchEventY, ev)){
                    mHandler.removeMessages(PRESS);
                    mIsLongPress.set(false);
                }
                break;
        }

        return false;
    }

    private void actionUp(MotionEvent ev){
        Log("onTouchEvent ACTION_UP");
        Log("ACTION_UP ev.getActionIndex()=  "+ev.getActionIndex());
        mPtrCount--;
        mPrimStartTouchEventX = -1;
        mPrimStartTouchEventY = -1;
        if(!mIsLongPress.getAndSet(false) && !mIsScrolling) {
            if (System.currentTimeMillis() - downTimestamp > 50) {
                if(mHandler.hasMessages(DOUBLE_TAP)){
                    mHandler.removeMessages(DOUBLE_TAP);
                    mHandler.sendEmptyMessageDelayed(TRIPLE_TAP,
                            0);
                }else if (!mHandler.hasMessages(TAP)) {

                    Log("ACTION_UP: not contain TAP mRealEvent X = "+mRealEvent.getX(ev.getActionIndex())+" ev.getX() = "+ev.getX(ev.getActionIndex())+" ev.getActionIndex()=  "+ev.getActionIndex());
                    Log("ACTION_UP: not contain TAP X distance = "+Math.abs(mRealEvent.getX(ev.getActionIndex()) - ev.getX(ev.getActionIndex()))+" SINGLE_TAPX_THRESHOLD = "+SINGLE_TAPX_THRESHOLD);
                    Log("ACTION_UP: not contain TAP Y distance = "+ Math.abs(mRealEvent.getY(ev.getActionIndex()) - ev.getY(ev.getActionIndex()))+" SINGLE_TAPY_THRESHOLD = "+SINGLE_TAPY_THRESHOLD);
                    if(mRealEvent!=null && Math.abs(mRealEvent.getX(ev.getActionIndex()) - ev.getX(ev.getActionIndex())) < SINGLE_TAPX_THRESHOLD &&
                            Math.abs(mRealEvent.getY(ev.getActionIndex()) - ev.getY(ev.getActionIndex())) < SINGLE_TAPY_THRESHOLD) {
                        Log("ACTION_UP: not contain send TAP");
                        mHandler.sendEmptyMessageDelayed(TAP,
                                DOUBLE_TAP_TIMEOUT);
                    }
                } else {
                    mHandler.removeMessages(TAP);
                    mHandler.sendEmptyMessageDelayed(DOUBLE_TAP,
                            DOUBLE_TAP_TIMEOUT);
                }
            }
        }

        downTimestamp = System.currentTimeMillis();

        if(mIsScrolling){
            cancelAll();
            mIsScrolling = false;
        }
        if(getOnScrollListener()!=null){
            getOnScrollListener().onMoveEnd(ev);
        }
        if (mHandler.hasMessages(PRESS)) {
            mHandler.removeMessages(PRESS);
        }
    }

    @Override
    public boolean onDoubleTap(MotionEvent e) {
//        Log("onDoubleTap() ptrs:" + e.getPointerCount());
//        if (mCurrentDownEvent.getPointerCount() == 1) {
//                Log( "onDoubleTap() ptrs:" + mCurrentDownEvent.getPointerCount());
//                mHandler.sendEmptyMessageDelayed(DOUBLE_TAP, DOUBLE_TAP_TIMEOUT);
//        }
        return true;
    }

    @Override
    public boolean onDoubleTapEvent(MotionEvent e) {
        Log("onDoubleTapEvent() ptrs:" + e.getPointerCount());

        return true;
    }
    public boolean onTripleTapConfirmed(MotionEvent e) {
        Log("onTripleTapConfirmed() ptrs:" + e.getPointerCount());

        int finger = e.getPointerCount();

        if(getOnTapListener()!=null) {
           getOnTapListener().onTripleTap(finger, e);
        }
        if (mPtrCount == 1) {
            Log("onDoubleTapConfirmed(): tap and a half");
        }
        return true;
    }
    public boolean onDoubleTapConfirmed(MotionEvent e) {
        Log("onDoubleTapConfirmed() ptrs:" + e.getPointerCount());

        int finger = e.getPointerCount();
        if(getOnTapListener()!=null) {
           getOnTapListener().onDoubleTap(finger, e);
        }
        if (mPtrCount == 1) {
            Log("onDoubleTapConfirmed(): tap and a half");
        }
        return true;
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent e) {
        if (!mHandler.hasMessages(TAP)
                && mCurrentDownEvent == e) {
            Log("onSingleTapConfirmed() ptrs:" + e.getPointerCount());

            int finger = e.getPointerCount();
            if(getOnTapListener()!=null) {
                getOnTapListener().onTapEvent(finger, e);
            }
        }

        if (mPtrCount == 1 && mCurrentDownEvent.getPointerCount() == 2) {
            // one finger is still down and a single tap occured
            Log("onSingleTapConfirmed(): One finger down, one finger tap");
        }
        return true;
    }

    @Override
    public boolean onDown(MotionEvent e) {
        Log("onDown() ptrs:" + e.getPointerCount()+" e.getX(): "+e.getX()+" e.getY(): "+e.getY());
        if (mCurrentDownEvent != null)
            mCurrentDownEvent.recycle();
            mCurrentDownEvent = MotionEvent.obtain(e);

        if (mRealEvent != null)
            mRealEvent.recycle();
            mRealEvent = MotionEvent.obtain(e);

        mPrimStartTouchEventX = e.getX();
        mPrimStartTouchEventY = e.getY();

        return true;
    }

    @Override
    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX,
                           float velocityY) {

        float diffX = e2.getX() - e1.getX();
        float diffY = e2.getY() - e1.getY();

        Log("onFling() ptrs: e1 =" + e1.getPointerCount()+" e2 = "+e2.getPointerCount() + ", diffX=" + diffX + ", diffY = " + diffY);
        if(getOnScrollListener()!=null){
            getOnScrollListener().onFling(e1,e2,velocityX,velocityY);
        }

        if (Math.abs(diffX) > Math.abs(diffY)) {
            if (Math.abs(diffX) > SWIPE_THRESHOLD && Math.abs(velocityX) > SWIPE_VELOCITY_THRESHOLD) {
                if (diffX > 0) {
                    if(getOnSwipeListener()!=null){
                       getOnSwipeListener().onSwipeRight();
                    }
                } else {
                    if(getOnSwipeListener()!=null){
                       getOnSwipeListener().onSwipeLeft();
                    }
                }
            }
        } else {
            if(Math.abs(diffY) > SWIPE_THRESHOLD && Math.abs(velocityY) > SWIPE_VELOCITY_THRESHOLD){
                if(diffY > 0){
                    if(getOnSwipeListener()!=null){
                        getOnSwipeListener().onSwipeDown();
                    }
                }else{
                    if(getOnSwipeListener()!=null){
                        getOnSwipeListener().onSwipeUp();
                    }
                }
            }
        }

        return true;
    }
public void onZeissLongPress(MotionEvent e){
    if(mCurrentDownEvent!=null && e.getPointerCount() != mCurrentDownEvent.getPointerCount()){
        return;
    }
    Log("onLongPress() ptrs: = " + e.getPointerCount());
    mIsLongPress.set(true);

    int finger = e.getPointerCount();
    if(getOnLongPressListener()!=null) {
        getOnLongPressListener().onLongPress(finger,e);
    }
}
    @Override
    public void onLongPress(MotionEvent e) {
//        if(mCurrentDownEvent!=null && e.getPointerCount() != mCurrentDownEvent.getPointerCount()){
//            return;
//        }
//        Log("onLongPress() ptrs: = " + e.getPointerCount());
//        mIsLongPress.set(true);
//
//        int finger = e.getPointerCount();
//        if(getOnLongPressListener()!=null) {
//           getOnLongPressListener().onLongPress(finger,e);
//        }
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX,
                            float distanceY) {
        // e1 The first down motion event that started the scrolling.
        // e2 The move motion event that triggered the current onScroll.
        Log("onScroll() ptrs:e1:" + e1.getPointerCount() + " e2:"
                + e2.getPointerCount() + " ptrCnt: " + mPtrCount );

        boolean scroll = isScrollGesture(e2);
        boolean pinch = isPinchGesture(e2);

        Log("onScroll() scroll = " + scroll + " pinch = " + pinch);

        if (scroll || pinch) {
            cancelAll();
        }

        if (!pinch && scroll) {
            mIsScrolling = true;
            if(getOnScrollListener()!=null){
                getOnScrollListener().onMove(e1,e2,distanceX,distanceY,true);
            }

            return true;
        }else if(!pinch){
            if(getOnScrollListener()!=null){
                getOnScrollListener().onMove(e1,e2,distanceX,distanceY,false);
            }
        }

        return false;
    }

    @Override
    public void onShowPress(MotionEvent e) {
        Log("onShowPress() ptrs:" + e.getPointerCount());

    }

    @Override
    public boolean onSingleTapUp(MotionEvent e) {
        Log("onSingleTapUp() ptrs:" + e.getPointerCount());
        return true;
    }

    private void cancelAll() {
        if (mHandler.hasMessages(TAP))
            mHandler.removeMessages(TAP);
    }

    private boolean isPinchGesture(MotionEvent event) {
        if (event.getPointerCount() == 2) {
            final float distanceCurrent = distance(event, 0, 1);
            final float diffPrimX = mPrimStartTouchEventX - event.getX(0);
            final float diffPrimY = mPrimStartTouchEventY - event.getY(0);
            final float diffSecX = mSecStartTouchEventX - event.getX(1);
            final float diffSecY = mSecStartTouchEventY - event.getY(1);

            if (// if the distance between the two fingers has increased past
                // our threshold
                    Math.abs(distanceCurrent - mPrimSecStartTouchDistance) > mViewScaledTouchSlop
                            // and the fingers are moving in opposing directions
                            && (diffPrimY * diffSecY) <= 0
                            && (diffPrimX * diffSecX) <= 0) {
                // mPinchClamp = false; // don't clamp initially
                return true;
            }
        }

        return false;
    }

    private float distance(MotionEvent event, int first, int second) {
        if (event.getPointerCount() >= 2) {
            final float x = event.getX(first) - event.getX(second);
            final float y = event.getY(first) - event.getY(second);

            return (float) Math.sqrt(x * x + y * y);
        } else {
            return 0;
        }
    }

    private boolean isScrollGesture(MotionEvent event) {
        if (event.getPointerCount() == 2) {
            final float diffPrim = mPrimStartTouchEventY - event.getY(0);
            final float diffSec = mSecStartTouchEventY - event.getY(1);

            if (// make sure both fingers are moving in the same direction
                    diffPrim * diffSec > 0
                            // make sure both fingers have moved past the scrolling
                            // threshold
                            && Math.abs(diffPrim) > mViewScaledTouchSlop
                            && Math.abs(diffSec) > mViewScaledTouchSlop) {
                return true;
            }
        } else if (event.getPointerCount() == 1) {
            final float diffPrim = mPrimStartTouchEventY - event.getY(0);
            if (// make sure finger has moved past the scrolling threshold
                    Math.abs(diffPrim) > mViewScaledTouchSlop) {
                return true;
            }
        }

        return false;
    }

    private boolean isMove(float prevX, float prevY, MotionEvent event){
        return (Math.abs(prevX - event.getX()) > SCROLL_THRESHOLD
                || Math.abs(prevY - event.getY()) > SCROLL_THRESHOLD);
    }
    private void Log(String msg){
        if(Util.DEBUG) {
            Log.e(TAG, "" + msg);
        }
    }

}