package zeiss.gesture.manager;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;

import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;

import example.givemepass.aidlremotedemo.IRemoteAIDL;
import example.givemepass.aidlremotedemo.IRemoteAIDLCallback;

/**
 * Created by dennis on 17/5/2017.
 */

public class AIDLBluetoothManager {
    private static final  String TAG =  "AIDLBluetoothManager";
    public class BluetoothItem{
        BLUE_STATUS status;
        String result;

        public BLUE_STATUS getStatus() {
            return status;
        }

        public void setStatus(BLUE_STATUS status) {
            this.status = status;
        }

        public String getResult() {
            return result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }
    public enum BLUE_STATUS {
        CONNECTED,
        DISCONNECT
    }
    public interface CallBack{
        void onBlueToothStatusChange(BluetoothItem msg);
    }
    private IRemoteAIDL mService;
    private static final int KEY_BLUETOOTH_STATUS_UPDATE = 1;
    private CallBack mCallBack;
    private Handler mHandler;

    public void bindService(Context context){
        if(mConnection!=null && context!=null) {
            Log.d("Dennis", "bindService");
            Intent intent = new Intent();
            intent.setAction("service.remote");
            intent.setPackage("example.givemepass.aidlremotedemo");
            boolean isBind = context.bindService(intent, mConnection, Context.BIND_AUTO_CREATE);
            Log.d(TAG,"bindService isBind = "+isBind);
        }
    }

    public void unBindService(Context context){
        if(mConnection!=null && context!=null) {
            Log.d("Dennis", "unBindService");
            context.unbindService(mConnection);
        }
    }

    public AIDLBluetoothManager(CallBack callBack) {
        mCallBack = callBack;
        mHandler =  new Handler(){
            @Override
            public void handleMessage(Message msg) {
                switch (msg.what){
                    case KEY_BLUETOOTH_STATUS_UPDATE:
                        if(mCallBack!=null) {
                            BluetoothItem item = (BluetoothItem) msg.obj;
                            mCallBack.onBlueToothStatusChange(item);
                        }
                        break;
                }

            }
        };
    }

    private ServiceConnection mConnection = new ServiceConnection() {
        public void onServiceConnected(ComponentName className, IBinder service) {
            mService = IRemoteAIDL.Stub.asInterface(service);
            try {
                mService.getRemoteName(new IRemoteAIDLCallback.Stub(){
                    @Override
                    public void handleMsg(final String name){
                        BluetoothItem item = new BluetoothItem();
                        item.setStatus(BLUE_STATUS.CONNECTED);
                        item.setResult(name);
                        sendMessage(item);
                    }
                });

                String status = mService.getStatus();
                BluetoothItem item = new BluetoothItem();
                item.setStatus(BLUE_STATUS.DISCONNECT);
                item.setResult(status);
                sendMessage(item);

            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            mService = null;
        }
    };

    private void sendMessage(BluetoothItem item){
        Message message = new Message();
        message.obj = item;
        message.what = KEY_BLUETOOTH_STATUS_UPDATE;
        mHandler.sendMessage(message);
    }
}
