package zeiss.gesture.statusbar;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;

import zeiss.gesture.R;
import zeiss.gesture.callback.StatusBarInterface;

/**
 * Created by dennis on 25/4/2017.
 */
public abstract class BaseStatusBar<T> implements StatusBarInterface<T> {
    private String TAG = BaseStatusBar.class.getName();
    private int defaultHeight;
    private int defaultMarginLeft,defaultMarginRight,defaultMarginTop,defaultMarginBottom;
    private RelativeLayout rootView;
    private RelativeLayout.LayoutParams mParams;
    public BaseStatusBar(Context context) {
        LayoutInflater mInflater = LayoutInflater.from(context);
        rootView = (RelativeLayout) mInflater.inflate(getLayoutId(),null);
        setDefaultLayoutParmas();
    }



    public void setDefaultLayoutParmas(){
        defaultHeight = (int) getRootView().getContext().getResources().getDimension(R.dimen.sb_height);
//        defaultMarginLeft = (int) getRootView().getContext().getResources().getDimension(R.dimen.sb_margin_left);
//        defaultMarginRight = (int) getRootView().getContext().getResources().getDimension(R.dimen.sb_margin_right);
        defaultMarginTop = (int) getRootView().getContext().getResources().getDimension(R.dimen.sb_margin_top);
        defaultMarginBottom = (int) getRootView().getContext().getResources().getDimension(R.dimen.sb_margin_bottom);
        mParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT,defaultHeight);
        mParams.setMargins(defaultMarginLeft,defaultMarginTop,defaultMarginRight,defaultMarginBottom);
        setLayoutParams(mParams);
    }

    public RelativeLayout getRootView(){
        return rootView;
    }
    @Override
    public void setLayoutParams(RelativeLayout.LayoutParams params){
        getRootView().setLayoutParams(params);
    }

    @Override
    public void setHeight(int height) {
        mParams.height = height;
        getRootView().setLayoutParams(mParams);
    }

    @Override
    public int getHeight(){
        return getRootView().getHeight();
    }
    @Override
    public int getWidth(){
        return getRootView().getWidth();
    }


}
