package zeiss.gesture.statusbar;

import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextClock;
import android.widget.TextView;

/**
 * Created by dennis on 8/5/2017.
 */
public class IStatusBar {
    public interface LifeCycle{
        void onResume();
        void onPause();
        void onDestory();
    }

    public interface AppView extends LifeCycle{
        void setTimeClockFormat(boolean is24HourFormat);
        TextView getTitle();
        void setTitleText(String text);
        TextClock getTimeClock();
        void defaultLayout();
        void displayItem(boolean isShow);

    }

    public interface LauncherView extends AppView {
        ProgressBar getBatteryProgressBar();
        ImageView getWifi();
        ImageView getPhoneConnect();
        void setItemSize(int height, int width);
        void showItem(StatusBarLauncher.LauncherHolder.Item item, boolean isShow);

    }

}
