package zeiss.gesture.statusbar;

import android.content.Context;
import android.text.format.DateFormat;
import android.view.View;
import android.widget.TextClock;
import android.widget.TextView;

import java.util.Calendar;
import java.util.TimeZone;

import zeiss.gesture.R;


/**
 * Created by dennis on 25/4/2017.
 */
public class StatusBarApp extends BaseStatusBar<StatusBarApp.AppHolder> {
    private String TAG = StatusBarApp.class.getName();
    private AppHolder mAppHolder;
    public StatusBarApp(Context context) {
        super(context);
        mAppHolder = new AppHolder(getRootView());
        fillContent();
        setValue();
    }

    @Override
    public AppHolder getHolder() {
        return mAppHolder;
    }

    @Override
    public int getLayoutId() {
        return R.layout.custom_status_bar_app;
    }


    public void fillContent() {}
    public void setValue() {
        mAppHolder.defaultLayout();
    }

    public static class AppHolder implements IStatusBar.AppView {
        TextView title;
        TextClock timeClock;
        View mView;
        public AppHolder(View view){
            mView = view;
            title = (TextView) view.findViewById(R.id.title);
            timeClock = (TextClock) view.findViewById(R.id.timeClock);
            onResume();
        }
        @Override
        public void setTimeClockFormat(boolean is24HourFormat){
            Calendar cal = Calendar.getInstance();
            TimeZone tz = cal.getTimeZone();
            timeClock.setTimeZone(tz.getID());
            if(is24HourFormat){
                timeClock.setFormat12Hour(null);
                timeClock.setFormat24Hour("H:mm");
            }else{
                timeClock.setFormat12Hour("hh:mm aa");
                timeClock.setFormat24Hour(null);
            }
        }
        @Override
        public TextView getTitle() {
            return title;
        }
        @Override
        public void setTitleText(String text){
            title.setText(text);
        }
        @Override
        public TextClock getTimeClock() {
            return timeClock;
        }
        @Override
        public void defaultLayout(){
//            Log.d("Dennis","AppHolder -- defaultLayout");
            getTitle().setVisibility(View.VISIBLE);
            getTimeClock().setVisibility(View.VISIBLE);
        }
        @Override
        public void displayItem(boolean isShow){
            title.setVisibility(isShow ? View.VISIBLE :View.GONE);
            timeClock.setVisibility(isShow ? View.VISIBLE :View.GONE);
        }

        @Override
        public void onResume(){
            setTimeClockFormat(DateFormat.is24HourFormat(timeClock.getContext()));
        }

        @Override
        public void onPause() {

        }

        @Override
        public void onDestory() {

        }
    }
}
