package zeiss.gesture.statusbar;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.PermissionChecker;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import zeiss.gesture.R;


/**
 * Created by dennis on 25/4/2017.
 */
public class StatusBarLauncher extends BaseStatusBar<StatusBarLauncher.LauncherHolder> {
    private String TAG = StatusBarLauncher.class.getName();

    private static final float BATTER_LOW_LIMIT = 0.20f;

    private LauncherHolder mLauncherHolder;

    public StatusBarLauncher(Context context) {
        super(context);
        mLauncherHolder = new LauncherHolder(getRootView());
        fillContent();
        setValue();
    }

    public void fillContent() {}

    public void setValue() {
        mLauncherHolder.defaultLayout();
    }

    @Override
    public LauncherHolder getHolder() {
        return mLauncherHolder;
    }

    @Override
    public int getLayoutId() {
        return R.layout.custom_status_bar_launcher;
    }


    public static class LauncherHolder extends StatusBarApp.AppHolder implements IStatusBar.LauncherView{
        public enum Item{
            BATTERY_STATUS,
            WIFI_STATUS,
            PHONE_CONNECT_STATUS
        }

        ImageView wifi;
        ImageView phoneConnect;
        ProgressBar batteryProgressBar;
        BatteryReceiver mBatteryReceiver;
        Drawable lowProgressDrawable,highProgressDrawable,chargeProgressDrawable;

        public LauncherHolder(View view){
            super(view);

            wifi = (ImageView) view.findViewById(R.id.wifi);
            phoneConnect = (ImageView) view.findViewById(R.id.phone_connect);
            batteryProgressBar = (ProgressBar) view.findViewById(R.id.batteryProgressBar);

            lowProgressDrawable = ContextCompat.getDrawable(mView.getContext(), R.drawable.battery_progress_bar_low);
            highProgressDrawable = ContextCompat.getDrawable(mView.getContext(), R.drawable.battery_progress_bar);
            chargeProgressDrawable = ContextCompat.getDrawable(mView.getContext(), R.drawable.battery_progress_bar_charge);

            mBatteryReceiver = new BatteryReceiver(new BatteryReceiver.BatteryReceiverCallback() {
                @Override
                public void onBatteryReceiver(BatteryReceiver.BATTERY_STATUS status, float battery_level) {
                    switch (status){
                        case IS_CHARGE:
                            if(batteryProgressBar!=null) {
                                batteryProgressBar.setProgressDrawable(null);
                                batteryProgressBar.setProgressDrawable(chargeProgressDrawable);
                                batteryProgressBar.setProgress((int) (battery_level * 100));
                                return;
                            }
                            break;
                        case IS_FULL:
                            break;
                        case IS_DISCHARGE:
                            break;
                        case UNKNOWN:
                            break;
                    }
                    Log.d("Dennis","status = "+status.toString()+" battery_level = "+battery_level);
                    if(batteryProgressBar!=null) {
                        if(battery_level < BATTER_LOW_LIMIT){
                            batteryProgressBar.setProgressDrawable(null);
                            batteryProgressBar.setProgressDrawable(lowProgressDrawable);
                        }else{
                            batteryProgressBar.setProgressDrawable(null);
                            batteryProgressBar.setProgressDrawable(highProgressDrawable);
                        }
                        batteryProgressBar.setProgress((int) (battery_level * 100));
                    }
                }
            });

        }

        @Override
        public ImageView getWifi() {
            return wifi;
        }
        @Override
        public ImageView getPhoneConnect() {
            return phoneConnect;
        }
        @Override
        public ProgressBar getBatteryProgressBar() {
            return batteryProgressBar;
        }


        @Override
        public void setItemSize(int height, int width){
//            getWifi().setLayoutParams(new LinearLayout.LayoutParams(height,width));
//            getPhoneConnect().setLayoutParams(new LinearLayout.LayoutParams(height,width));
        }

        @Override
        public void defaultLayout(){
            Log.d("Dennis","LauncherView -- defaultLayout");
            getBatteryProgressBar().setVisibility(View.VISIBLE);
            getWifi().setVisibility(View.GONE);
            getPhoneConnect().setVisibility(View.GONE);
            getTitle().setVisibility(View.GONE);
            getTimeClock().setVisibility(View.VISIBLE);
        }

        @Override
        public void displayItem(boolean isShow){
            super.displayItem(isShow);
            getBatteryProgressBar().setVisibility(View.GONE);
            getWifi().setVisibility(isShow ? View.VISIBLE :View.GONE);
            getPhoneConnect().setVisibility(isShow ? View.VISIBLE :View.GONE);
        }

        @Override
        public void showItem(Item item, boolean isShow){
            switch (item){
                case BATTERY_STATUS:
                    getBatteryProgressBar().setVisibility(isShow ? View.VISIBLE :View.GONE);
                    break;
                case WIFI_STATUS:
                    getWifi().setVisibility(isShow ? View.VISIBLE :View.GONE);
                    break;
                case PHONE_CONNECT_STATUS:
                    getPhoneConnect().setVisibility(isShow ? View.VISIBLE :View.GONE);
                    break;
            }
        }

        @Override
        public void onResume() {
            super.onResume();
            if(mView!=null&& mBatteryReceiver!=null) {
                mView.getContext().registerReceiver(mBatteryReceiver, mBatteryReceiver.getFilter());
                Log.d("Dennis","onResume - LauncherHolder");
            }
        }

        @Override
        public void onPause() {
            super.onPause();
            if(mView!=null&& mBatteryReceiver!=null) {
                mView.getContext().unregisterReceiver(mBatteryReceiver);
            }
        }

        @Override
        public void onDestory(){
            super.onDestory();
            lowProgressDrawable = null;
            highProgressDrawable = null;
        }

    }
}
